/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.work;

import commonj.work.WorkItem;
import de.myfoo.commonj.work.FooWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ResultCollector {
    private int workCount = 0;
    private int expectedWorkCount = 0;
    private long timeout;
    private List<WorkItem> workItems = new ArrayList<WorkItem>();

    public ResultCollector(long timeoutMs) {
        this.timeout = timeoutMs;
    }

    public synchronized boolean waitForAll() throws InterruptedException {
        boolean timedOut = false;
        long endTime = 0L;
        if (this.timeout == 0L) {
            return this.allItemsDone();
        }
        endTime = this.timeout == Long.MAX_VALUE ? this.timeout : System.currentTimeMillis() + this.timeout;
        if (this.allItemsDone()) {
            return true;
        }
        while (this.workCount < this.expectedWorkCount) {
            this.wait(10L);
            if (System.currentTimeMillis() >= endTime) {
                timedOut = true;
                break;
            }
            if (!this.allItemsDone()) continue;
        }
        this.notifyAll();
        return !timedOut;
    }

    private boolean allItemsDone() {
        for (WorkItem workItem : this.workItems) {
            if (workItem.getStatus() == 4) continue;
            return false;
        }
        return true;
    }

    public synchronized Collection<WorkItem> waitForAny() throws InterruptedException {
        long endTime = 0L;
        if (this.timeout == 0L) {
            return this.itemsDone();
        }
        endTime = this.timeout == Long.MAX_VALUE ? this.timeout : System.currentTimeMillis() + this.timeout;
        while (this.workCount == 0) {
            this.wait(10L);
            if (System.currentTimeMillis() < endTime && this.itemsDone().isEmpty()) continue;
        }
        this.notifyAll();
        return this.itemsDone();
    }

    private Collection<WorkItem> itemsDone() {
        ArrayList<WorkItem> items = new ArrayList<WorkItem>();
        for (WorkItem workItem : this.workItems) {
            if (workItem.getStatus() != 4) continue;
            items.add(workItem);
        }
        return items;
    }

    public synchronized void workDone() {
        ++this.workCount;
        this.notifyAll();
    }

    public void addWorkItem(WorkItem workItem) {
        this.workItems.add(workItem);
        if (workItem instanceof FooWorkItem) {
            FooWorkItem fwi = (FooWorkItem)workItem;
            fwi.setResultCollector(this);
        }
        ++this.expectedWorkCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

