/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.work;

import de.myfoo.commonj.util.AbstractFactory;
import de.myfoo.commonj.util.ThreadPool;
import de.myfoo.commonj.work.FooWorkManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;

public final class FooWorkManagerFactory
extends AbstractFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        FooWorkManager workManager = (FooWorkManager)this.managers.get(name);
        if (workManager == null) {
            int minThreads = 2;
            int maxThreads = 10;
            int queueLength = 10;
            int maxDaemons = 10;
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> addrs = ref.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr addr = addrs.nextElement();
                String addrName = addr.getType();
                String addrValue = (String)addr.getContent();
                switch (addrName) {
                    case "maxThreads": {
                        maxThreads = this.getValue(addrName, addrValue);
                        break;
                    }
                    case "minThreads": {
                        minThreads = this.getValue(addrName, addrValue);
                        break;
                    }
                    case "queueLength": {
                        queueLength = this.getValue(addrName, addrValue);
                        break;
                    }
                    case "maxDaemons": {
                        maxDaemons = this.getValue(addrName, addrValue);
                    }
                }
            }
            if (minThreads < 1) {
                throw new NamingException("minThreads can not be < 1 but is " + minThreads);
            }
            if (minThreads > maxThreads) {
                throw new NamingException(String.format("minThreads (%d) can not be greater than maxThreads (%d)", minThreads, maxThreads));
            }
            ThreadPool pool = new ThreadPool(minThreads, maxThreads, queueLength);
            workManager = new FooWorkManager(pool, maxDaemons);
            this.managers.put(name, workManager);
        }
        return workManager;
    }
}

