/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.work;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import de.myfoo.commonj.util.AbstractManager;
import de.myfoo.commonj.util.ThreadPool;
import de.myfoo.commonj.work.FooRemoteWorkItem;
import de.myfoo.commonj.work.FooWorkItem;
import de.myfoo.commonj.work.ResultCollector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class FooWorkManager
extends AbstractManager
implements WorkManager {
    private int maxDaemons = 10;
    private List<WorkItem> daemons = new ArrayList<WorkItem>();

    public FooWorkManager(ThreadPool pool) {
        super(pool);
    }

    public FooWorkManager(ThreadPool pool, int maxDaemons) {
        this(pool);
        this.maxDaemons = maxDaemons;
    }

    public WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.schedule(work, null);
    }

    public WorkItem schedule(Work work, WorkListener wl) throws WorkException, IllegalArgumentException {
        this.checkWork(work);
        FooWorkItem workItem = null;
        workItem = work instanceof Serializable ? new FooRemoteWorkItem(work, wl, this) : new FooWorkItem(work, wl);
        try {
            if (work.isDaemon()) {
                if (this.daemons.size() >= this.maxDaemons) {
                    throw new WorkException("Too many daemons running: " + this.maxDaemons);
                }
                this.daemons.add(workItem);
                workItem.setDaemons(this.daemons);
                Thread thread = new Thread(workItem);
                thread.start();
            } else {
                this.pool.execute(workItem);
            }
        }
        catch (InterruptedException e) {
            throw new WorkException("Failed to execute work: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WorkException("Failed to execute work: " + e.getMessage(), (Throwable)e);
        }
        return workItem;
    }

    public boolean waitForAll(Collection workItems, long timeoutMs) throws InterruptedException, IllegalArgumentException {
        this.checkTimeout(timeoutMs);
        if (workItems == null || workItems.isEmpty()) {
            throw new IllegalArgumentException("null or empty work items.");
        }
        ResultCollector rc = new ResultCollector(timeoutMs);
        for (WorkItem workItem : workItems) {
            rc.addWorkItem(workItem);
        }
        return rc.waitForAll();
    }

    public Collection waitForAny(Collection workItems, long timeoutMs) throws InterruptedException, IllegalArgumentException {
        if (workItems != null && workItems.isEmpty()) {
            return new ArrayList();
        }
        this.checkTimeout(timeoutMs);
        if (workItems == null || workItems.isEmpty()) {
            throw new IllegalArgumentException("null or empty work items.");
        }
        ResultCollector rc = new ResultCollector(timeoutMs);
        for (WorkItem workItem : workItems) {
            rc.addWorkItem(workItem);
        }
        return rc.waitForAny();
    }

    private void checkTimeout(long timeoutMs) throws IllegalArgumentException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Invalid timeout: " + timeoutMs);
        }
    }

    private void checkWork(Work work) throws IllegalArgumentException {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (WorkItem workItem : this.daemons) {
            try {
                Work work = workItem.getResult();
                work.release();
            }
            catch (WorkException workException) {}
        }
    }

    @Override
    public void forceShutdown() {
        super.forceShutdown();
        for (WorkItem workItem : this.daemons) {
            try {
                Work work = workItem.getResult();
                work.release();
            }
            catch (WorkException workException) {}
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public int getMaxDaemons() {
        return this.maxDaemons;
    }

    public void setMaxDaemons(int maxDaemons) {
        this.maxDaemons = maxDaemons;
    }
}

