/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPool {
    private ThreadPoolExecutor pool;
    private int queueLength = 20;

    public ThreadPool(int minThreads, int maxThreads, int queueLength) {
        this.queueLength = queueLength;
        this.pool = new ThreadPoolExecutor(minThreads, maxThreads, 20L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueLength), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public int getCoreThreads() {
        return this.pool.getCorePoolSize();
    }

    public void setCoreThreads(int coreThreads) {
        this.pool.setCorePoolSize(coreThreads);
    }

    public int getMaxThreads() {
        return this.pool.getMaximumPoolSize();
    }

    public void setMaxThreads(int maxThreads) {
        this.pool.setMaximumPoolSize(maxThreads);
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public void execute(Runnable command) throws InterruptedException {
        this.pool.execute(command);
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public void forceShutdown() {
        this.pool.shutdownNow();
    }
}

