/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.timers;

import de.myfoo.commonj.timers.FooTimerManager;
import de.myfoo.commonj.util.AbstractFactory;
import de.myfoo.commonj.util.ThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;

public final class FooTimerManagerFactory
extends AbstractFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        FooTimerManager timerManager = (FooTimerManager)this.managers.get(name);
        if (timerManager == null) {
            int minThreads = 2;
            int maxThreads = 10;
            int queueLength = 10;
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> addrs = ref.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr addr = addrs.nextElement();
                String addrName = addr.getType();
                String addrValue = (String)addr.getContent();
                if (addrName.equals("maxThreads")) {
                    maxThreads = this.getValue(addrName, addrValue);
                    continue;
                }
                if (addrName.equals("minThreads")) {
                    minThreads = this.getValue(addrName, addrValue);
                    continue;
                }
                if (!addrName.equals("queueLength")) continue;
                queueLength = this.getValue(addrName, addrValue);
            }
            if (minThreads < 1) {
                throw new NamingException("minThreads can not be < 1.");
            }
            if (minThreads >= maxThreads) {
                throw new NamingException("minThreads can not be >= maxThreads.");
            }
            ThreadPool pool = new ThreadPool(minThreads, maxThreads, queueLength);
            timerManager = new FooTimerManager(pool);
            this.managers.put(name, timerManager);
        }
        return timerManager;
    }
}

