/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.timers;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import commonj.timers.TimerManager;
import de.myfoo.commonj.timers.FixedDelayTimer;
import de.myfoo.commonj.timers.FixedRateTimer;
import de.myfoo.commonj.timers.FooTimer;
import de.myfoo.commonj.timers.OneShotTimer;
import de.myfoo.commonj.timers.TimerExecutor;
import de.myfoo.commonj.util.AbstractManager;
import de.myfoo.commonj.util.ThreadPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class FooTimerManager
extends AbstractManager
implements TimerManager,
Runnable {
    private boolean stopped = false;
    private boolean stopping = false;
    private boolean suspended = false;
    private boolean suspending = false;
    private List<TimerExecutor> timers = new ArrayList<TimerExecutor>();
    private Thread timerThread = new Thread(this);

    public FooTimerManager(ThreadPool pool) {
        super(pool);
        this.timerThread.start();
    }

    @Override
    public void shutdown() {
        if (!this.stopped) {
            this.stop();
        }
        this.pool.shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            long nextTime = System.currentTimeMillis() + 1000L;
            FooTimerManager fooTimerManager = this;
            synchronized (fooTimerManager) {
                long waitTime;
                Iterator<TimerExecutor> iter = this.timers.iterator();
                while (iter.hasNext()) {
                    TimerExecutor timerExecutor = iter.next();
                    FooTimer timer = timerExecutor.getTimer();
                    if (timer.isExpired() && !timerExecutor.isRunning()) {
                        if (!this.suspended && !this.suspending) {
                            try {
                                this.pool.execute(timerExecutor);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!(timer instanceof OneShotTimer)) continue;
                        iter.remove();
                        continue;
                    }
                    long time = timer.getScheduledExecutionTime();
                    if (time >= nextTime) continue;
                    nextTime = time;
                }
                boolean running = false;
                for (TimerExecutor timerExecutor : this.timers) {
                    if (!timerExecutor.isRunning()) continue;
                    running = true;
                }
                if (this.suspending && !running) {
                    this.suspended = true;
                }
                if (this.stopping && !running) {
                    this.stopped = true;
                }
                if ((waitTime = nextTime - System.currentTimeMillis()) > 0L) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isSuspended() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        return this.suspended;
    }

    public boolean isSuspending() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        return this.suspending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        FooTimerManager fooTimerManager = this;
        synchronized (fooTimerManager) {
            this.suspended = false;
            this.suspending = false;
            this.notifyAll();
        }
    }

    public Timer schedule(TimerListener listener, Date time) throws IllegalArgumentException, IllegalStateException {
        if (time == null) {
            throw new IllegalArgumentException("time is null.");
        }
        return this.scheduleOneShotTimer(listener, time.getTime());
    }

    public Timer schedule(TimerListener listener, long delay) throws IllegalArgumentException, IllegalStateException {
        if (delay < 0L) {
            throw new IllegalArgumentException("dealy is negative.");
        }
        return this.scheduleOneShotTimer(listener, System.currentTimeMillis() + delay);
    }

    public Timer schedule(TimerListener listener, Date firstTime, long period) throws IllegalArgumentException, IllegalStateException {
        if (firstTime == null) {
            throw new IllegalArgumentException("firstTime is null.");
        }
        return this.scheduleFixedDelayTimer(listener, firstTime.getTime(), period);
    }

    public Timer schedule(TimerListener listener, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        if (delay < 0L) {
            throw new IllegalArgumentException("dealy is negative.");
        }
        return this.scheduleFixedDelayTimer(listener, System.currentTimeMillis() + delay, period);
    }

    public Timer scheduleAtFixedRate(TimerListener listener, Date firstTime, long period) throws IllegalArgumentException, IllegalStateException {
        if (firstTime == null) {
            throw new IllegalArgumentException("firstTime is null.");
        }
        return this.scheduleFixedRateTimer(listener, firstTime.getTime(), period);
    }

    public Timer scheduleAtFixedRate(TimerListener listener, long delay, long period) throws IllegalArgumentException, IllegalStateException {
        if (delay < 0L) {
            throw new IllegalArgumentException("dealy is negative.");
        }
        return this.scheduleFixedRateTimer(listener, System.currentTimeMillis() + delay, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        FooTimerManager fooTimerManager = this;
        synchronized (fooTimerManager) {
            this.stopping = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        FooTimerManager fooTimerManager = this;
        synchronized (fooTimerManager) {
            this.suspending = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStop(long timeoutMs) throws InterruptedException, IllegalArgumentException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("timeout is negative.");
        }
        long endTime = System.currentTimeMillis() + timeoutMs;
        FooTimerManager fooTimerManager = this;
        synchronized (fooTimerManager) {
            while (!this.stopped && timeoutMs != 0L && System.currentTimeMillis() < endTime) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) continue;
                this.wait(waitTime);
            }
        }
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSuspend(long timeoutMs) throws InterruptedException, IllegalStateException, IllegalArgumentException {
        if (this.stopped) {
            throw new IllegalStateException("Already stopped.");
        }
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("timeout is negative.");
        }
        long endTime = System.currentTimeMillis() + timeoutMs;
        FooTimerManager fooTimerManager = this;
        synchronized (fooTimerManager) {
            while (!this.suspended && timeoutMs != 0L && System.currentTimeMillis() < endTime) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) continue;
                this.wait(waitTime);
            }
        }
        return this.suspended;
    }

    private FooTimer scheduleOneShotTimer(TimerListener listener, long time) throws IllegalStateException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        OneShotTimer timer = new OneShotTimer(time, listener);
        this.scheduleTimer(timer);
        return timer;
    }

    private FooTimer scheduleFixedDelayTimer(TimerListener listener, long time, long period) throws IllegalStateException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        if (period < 1L) {
            throw new IllegalArgumentException("period < 1.");
        }
        FixedDelayTimer timer = new FixedDelayTimer(time, period, listener);
        this.scheduleTimer(timer);
        return timer;
    }

    private FooTimer scheduleFixedRateTimer(TimerListener listener, long time, long period) throws IllegalStateException, IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        if (period < 1L) {
            throw new IllegalArgumentException("period < 1.");
        }
        FixedRateTimer timer = new FixedRateTimer(time, period, listener);
        this.scheduleTimer(timer);
        return timer;
    }

    private synchronized void scheduleTimer(FooTimer timer) throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("TimerManager is stopped.");
        }
        this.timers.add(new TimerExecutor(timer, this));
        this.notifyAll();
    }
}

