/*
 * Decompiled with CFR 0.152.
 */
package de.myfoo.commonj.timers;

import commonj.timers.StopTimerListener;
import commonj.timers.Timer;
import commonj.timers.TimerListener;

public abstract class FooTimer
implements Timer {
    protected boolean stopped = false;
    private boolean cancelled = false;
    protected long scheduledExcecutionTime;
    protected long period = 0L;
    private TimerListener listener;

    public FooTimer(long startTime, long period, TimerListener listener) {
        this.scheduledExcecutionTime = startTime;
        this.period = period;
        this.listener = listener;
    }

    protected abstract void computeNextExecutionTime();

    public void execute() {
        this.listener.timerExpired((Timer)this);
    }

    public boolean cancel() {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        return true;
    }

    public TimerListener getTimerListener() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Timer has already been stopped.");
        }
        return this.listener;
    }

    public long getScheduledExecutionTime() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("Timer has already been stopped.");
        }
        return this.scheduledExcecutionTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void stop() {
        this.stopped = true;
        if (this.listener instanceof StopTimerListener) {
            StopTimerListener stl = (StopTimerListener)this.listener;
            stl.timerStop((Timer)this);
        }
    }

    public boolean isExpired() {
        return this.scheduledExcecutionTime >= System.currentTimeMillis();
    }
}

