#!/bin/bash

set -e

JAVA_OPTIONS="-Xmx1024m -XX:+DisableExplicitGC -XX:+UseG1GC"
JAVA_DUMP_OPTIONS="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/tmp/solr_%p.hprof"
SOLR_STOP_OPTIONS="-DSTOP.PORT=9983 -DSTOP.KEY=nuba"
SOLR_LOGGING="-Dlog4j.configuration=file:etc/log4j.properties"
SOLR_OPTIONS="-Dsolr.solr.home=multicore -Dorg.mortbay.util.URI.charset=UTF-8"

JAVA_HOME="/usr/lib/jvm/java-8-openjdk-amd64"
export JAVA_HOME
JAVA_CMD="${JAVA_HOME}/bin/java"

${JAVA_CMD} ${JAVA_OPTIONS} ${JAVA_DUMP_OPTIONS} ${SOLR_OPTIONS} ${SOLR_LOGGING} ${SOLR_STOP_OPTIONS}  -jar start.jar
