/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xsltfilter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.carrot2.util.xslt.TemplatesPool;
import org.carrot2.util.xsltfilter.DeferredOutputStream;
import org.carrot2.util.xsltfilter.IContentTypeListener;
import org.carrot2.util.xsltfilter.TransformingDocumentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XSLTFilterServletResponse
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(XSLTFilterServletResponse.class);
    private boolean passthrough;
    private HttpServletResponse origResponse = null;
    private HttpServletRequest origRequest;
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;
    private TemplatesPool transformers;
    private ServletContext context;

    public XSLTFilterServletResponse(HttpServletResponse response, HttpServletRequest request, ServletContext context, TemplatesPool transformers) {
        super(response);
        this.origResponse = response;
        this.transformers = transformers;
        this.origRequest = request;
        this.context = context;
    }

    public void setContentType(String contentType) {
        boolean processingSuppressed = this.processingSuppressed(this.origRequest);
        if (processingSuppressed) {
            log.debug("XSLT processing disabled for the request.");
        }
        if (!processingSuppressed && (contentType.startsWith("text/xml") || contentType.startsWith("application/xml"))) {
            this.origResponse.setContentType("text/html; charset=UTF-8");
        } else {
            if (!processingSuppressed) {
                log.info("Content type is not text/xml or application/xml (" + contentType + "), passthrough.");
            }
            this.origResponse.setContentType(contentType);
            this.passthrough = true;
            if (this.stream != null && this.stream instanceof DeferredOutputStream) {
                try {
                    ((DeferredOutputStream)this.stream).passthrough((OutputStream)this.origResponse.getOutputStream());
                }
                catch (IOException e) {
                    ((DeferredOutputStream)this.stream).setExceptionOnNext(e);
                }
            }
        }
    }

    private boolean processingSuppressed(HttpServletRequest origRequest2) {
        return this.origRequest.getAttribute("xslt.filter:disable") != null | this.origRequest.getParameter("xslt.filter:disable") != null;
    }

    public void setContentLength(int length) {
        log.debug("Original content length (ignored): " + length);
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Character stream has been already initialized. Use streams consequently.");
        }
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = this.passthrough ? this.origResponse.getOutputStream() : new DeferredOutputStream();
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException("Byte stream has been already initialized. Use streams consequently.");
        }
        if (this.writer != null) {
            return this.writer;
        }
        if (this.passthrough) {
            this.writer = this.origResponse.getWriter();
            return this.writer;
        }
        String charEnc = this.origResponse.getCharacterEncoding();
        this.stream = new DeferredOutputStream();
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    void finishResponse() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.stream != null) {
            this.stream.close();
        }
        if (!this.passthrough && this.stream != null) {
            byte[] bytes = ((DeferredOutputStream)this.stream).getBytes();
            boolean processingSuppressed = this.origRequest.getAttribute("xslt.filter:disable") != null | this.origRequest.getParameter("xslt.filter:disable") != null;
            if (processingSuppressed) {
                ServletOutputStream os = this.origResponse.getOutputStream();
                os.write(bytes);
                os.close();
            } else {
                try {
                    this.processWithXslt(bytes, (Map)this.origRequest.getAttribute("xslt.filter:stylesheet-params"), this.origResponse);
                }
                catch (TransformerException e) {
                    Throwable t = this.unwrapCause(e);
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    this.filterError("Error applying stylesheet.", e);
                }
            }
        }
    }

    private Throwable unwrapCause(TransformerException e) {
        Throwable t;
        if (e.getException() != null) {
            t = e.getException();
        } else if (e.getCause() != null) {
            t = e.getCause();
        } else {
            return e;
        }
        while (true) {
            if (t instanceof IOException) {
                return t;
            }
            if (t.getCause() != null) {
                t = t.getCause();
                continue;
            }
            if (!(t instanceof SAXException) || ((SAXException)t).getException() == null) break;
            t = ((SAXException)t).getException();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithXslt(byte[] bytes, Map<String, Object> stylesheetParams, final HttpServletResponse response) throws TransformerConfigurationException, TransformerException, IOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            final TransformingDocumentHandler docHandler = new TransformingDocumentHandler(this.origRequest, this.context, stylesheetParams, this.transformers);
            docHandler.setContentTypeListener(new IContentTypeListener(){

                public void setContentType(String contentType, String encoding) {
                    if (encoding == null) {
                        response.setContentType(contentType);
                    } else {
                        response.setContentType(contentType + "; charset=" + encoding);
                    }
                    try {
                        docHandler.setTransformationResult(new StreamResult((OutputStream)response.getOutputStream()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not open output stream.");
                    }
                }
            });
            reader.setContentHandler(docHandler);
            try {
                reader.parse(new InputSource(new ByteArrayInputStream(bytes)));
            }
            finally {
                docHandler.cleanup();
            }
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested != null) {
                if (nested instanceof IOException) {
                    throw (IOException)nested;
                }
                if (nested instanceof TransformerException) {
                    throw (TransformerException)nested;
                }
            }
            throw new TransformerException("Input parsing exception.", e);
        }
    }

    protected void filterError(String message, Throwable t) {
        log.error("XSLT filter error: " + message, t);
        if (!this.origResponse.isCommitted()) {
            this.origResponse.reset();
            this.origResponse.setStatus(500);
            this.origResponse.setContentType("text/html; charset=UTF-8");
        }
        try {
            ServletOutputStream os = this.origResponse.getOutputStream();
            PrintWriter osw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "iso8859-1"));
            osw.write("<html><body><!-- xslt.filter:error -->");
            osw.write("<h1 style=\"color: red; margin-top: 1em;\">");
            osw.write("Internal server exception");
            osw.write("</h1>");
            osw.write("<b>URI</b>: " + this.origRequest.getRequestURI() + "\n<br/><br/>");
            this.serializeException(osw, t);
            if (t instanceof ServletException && ((ServletException)t).getRootCause() != null) {
                osw.write("<br/><br/><h2>ServletException root cause:</h2>");
                this.serializeException(osw, ((ServletException)t).getRootCause());
            }
            osw.write("</body></html>");
            osw.flush();
        }
        catch (IOException e) {
            log.debug("Filter error could not be returned to client.");
        }
    }

    private final void serializeException(PrintWriter osw, Throwable t) {
        osw.write("<b>Exception</b>: " + t.toString() + "\n<br/><br/>");
        osw.write("<b>Stack trace:</b>");
        osw.write("<pre style=\"margin: 1px solid red; padding: 3px; font-family: sans-serif; font-size: small;\">");
        t.printStackTrace(osw);
        osw.write("</pre>");
    }

    private void detectErrorResponse(int errorCode) {
        if (errorCode != 202) {
            this.origRequest.setAttribute("xslt.filter:disable", (Object)Boolean.TRUE);
        }
    }

    public void sendError(int errorCode) throws IOException {
        this.detectErrorResponse(errorCode);
        super.sendError(errorCode);
    }

    public void sendError(int errorCode, String message) throws IOException {
        this.detectErrorResponse(errorCode);
        super.sendError(errorCode, message);
    }

    public void setStatus(int statusCode) {
        this.detectErrorResponse(statusCode);
        super.setStatus(statusCode);
    }

    public void setStatus(int statusCode, String message) {
        this.detectErrorResponse(statusCode);
        super.setStatus(statusCode, message);
    }
}

