/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.File;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class DirLocator
implements IResourceLocator {
    private File dir;

    public DirLocator(File dir) {
        this.dir = dir;
    }

    public DirLocator(String dirPath) {
        this(dirPath == null ? null : new File(dirPath));
    }

    public IResource[] getAll(String resource) {
        if (this.dir != null && this.dir.isDirectory() && this.dir.canRead()) {
            resource = resource.replace('/', File.separatorChar);
            while (resource.startsWith(File.separator)) {
                resource = resource.substring(1);
            }
            File resourceFile = new File(this.dir, resource);
            if (resourceFile.isFile() && resourceFile.canRead()) {
                return new IResource[]{new FileResource(resourceFile)};
            }
        }
        return new IResource[0];
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.dir);
    }

    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof DirLocator) {
            return ObjectUtils.equals((Object)this.dir, (Object)((DirLocator)target).dir);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [dir: " + (this.dir == null ? "null" : this.dir.getAbsolutePath()) + "]";
    }
}

