/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindableDescriptorUtils {
    private BindableDescriptorUtils() {
    }

    public static String getDescriptorClassName(String className) {
        String packageName = ClassUtils.getPackageName((String)className);
        String shortClassName = ClassUtils.getShortClassName((String)ClassUtils.getShortClassName((String)className));
        return packageName + (StringUtils.isEmpty((String)packageName) ? "" : ".") + shortClassName + "Descriptor";
    }

    public static Class<? extends IBindableDescriptor> getDescriptorClass(Class<?> clazz) {
        if (clazz.getAnnotation(Bindable.class) == null) {
            throw new IllegalArgumentException("Class not marked with @Bindable: " + clazz.getName());
        }
        ClassLoader cl = clazz.getClassLoader();
        String descriptorClassName = BindableDescriptorUtils.getDescriptorClassName(clazz.getName());
        try {
            return Class.forName(descriptorClassName, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError("Descriptor class not found: " + descriptorClassName);
        }
    }

    public static IBindableDescriptor getDescriptor(Class<?> clazz) {
        try {
            return BindableDescriptorUtils.getDescriptorClass(clazz).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

