/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import org.apache.mahout.math.function.DoubleComparator;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_ORDER = new NaturalOrderDoubleComparator();
    public static final DoubleComparator REVERSED_ORDER = new ReversedOrderDoubleComparator();

    private DoubleComparators() {
    }

    private static class ReversedOrderDoubleComparator
    implements DoubleComparator {
        private ReversedOrderDoubleComparator() {
        }

        public int compare(double v1, double v2) {
            return -Double.compare(v1, v2);
        }
    }

    private static class NaturalOrderDoubleComparator
    implements DoubleComparator {
        private NaturalOrderDoubleComparator() {
        }

        public int compare(double v1, double v2) {
            return Double.compare(v1, v2);
        }
    }
}

