/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.clustering;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.clustering.MultilingualClustering;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultilingualClusteringDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.clustering.MultilingualClustering";
    public final String prefix = "MultilingualClustering";
    public final String title = "A helper for clustering multilingual collections of documents";
    public final String label = "";
    public final String description = "The helper partitions the input documents by <code>org.carrot2.core.Document.LANGUAGE</code>, clusters each such monolingual partition separately and then aggregates the partial cluster lists based on the selected <code>LanguageAggregationStrategy</code>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "MultilingualClustering";
    }

    @Override
    public String getTitle() {
        return "A helper for clustering multilingual collections of documents";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "The helper partitions the input documents by <code>org.carrot2.core.Document.LANGUAGE</code>, clusters each such monolingual partition separately and then aggregates the partial cluster lists based on the selected <code>LanguageAggregationStrategy</code>.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(MultilingualClusteringDescriptor.attributes.languageAggregationStrategy);
        ownAttrs.add(MultilingualClusteringDescriptor.attributes.defaultLanguage);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(MultilingualClusteringDescriptor.attributes.languageAggregationStrategy);
        allAttrs.add(MultilingualClusteringDescriptor.attributes.defaultLanguage);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder languageAggregationStrategy(MultilingualClustering.LanguageAggregationStrategy value) {
            this.map.put("MultilingualClustering.languageAggregationStrategy", (Object)value);
            return this;
        }

        public AttributeBuilder languageAggregationStrategy(Class<? extends MultilingualClustering.LanguageAggregationStrategy> clazz) {
            this.map.put("MultilingualClustering.languageAggregationStrategy", clazz);
            return this;
        }

        public AttributeBuilder defaultLanguage(LanguageCode value) {
            this.map.put("MultilingualClustering.defaultLanguage", (Object)value);
            return this;
        }

        public AttributeBuilder defaultLanguage(Class<? extends LanguageCode> clazz) {
            this.map.put("MultilingualClustering.defaultLanguage", clazz);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo languageAggregationStrategy = new AttributeInfo("MultilingualClustering.languageAggregationStrategy", "org.carrot2.text.clustering.MultilingualClustering", "languageAggregationStrategy", "Language aggregation strategy. Determines how clusters generated for individual\nlanguages should be combined to form the final result. Please see\n{@link org.carrot2.text.clustering.MultilingualClustering.LanguageAggregationStrategy} \nfor the list of available options.", null, "Language aggregation strategy", "Determines how clusters generated for individual languages should be combined to form the final result. Please see <code>org.carrot2.text.clustering.MultilingualClustering.LanguageAggregationStrategy</code> for the list of available options.", "Multilingual clustering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo defaultLanguage = new AttributeInfo("MultilingualClustering.defaultLanguage", "org.carrot2.text.clustering.MultilingualClustering", "defaultLanguage", "Default clustering language. The default language to use for documents with\nundefined {@link org.carrot2.core.Document#LANGUAGE}.", null, "Default clustering language", "The default language to use for documents with undefined <code>org.carrot2.core.Document.LANGUAGE</code>.", "Multilingual clustering", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String LANGUAGE_AGGREGATION_STRATEGY = "MultilingualClustering.languageAggregationStrategy";
        public static final String DEFAULT_LANGUAGE = "MultilingualClustering.defaultLanguage";

        protected Keys() {
        }
    }
}

