/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.yahoo;

import java.util.concurrent.Callable;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.yahoo.YahooNewsSearchService;
import org.carrot2.source.yahoo.YahooSearchService;
import org.carrot2.source.yahoo.YahooWebSearchService;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="YahooDocumentSource")
public final class YahooDocumentSource
extends MultipageSearchEngine {
    static final Logger logger = LoggerFactory.getLogger(YahooDocumentSource.class);
    private static final int MAX_CONCURRENT_THREADS = 10;
    @Input
    @Processing
    @Attribute
    public boolean keepHighlights = false;
    @Init
    @Input
    @Attribute
    @ImplementingClasses(classes={YahooWebSearchService.class, YahooNewsSearchService.class})
    public YahooSearchService service = new YahooWebSearchService();

    @Override
    public void process() throws ProcessingException {
        super.process(this.service.metadata, this.getSharedExecutor(10, this.getClass()));
    }

    @Override
    protected final Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            public SearchEngineResponse search() throws Exception {
                return YahooDocumentSource.this.service.query(YahooDocumentSource.this.query, bucket.start, bucket.results);
            }
        };
    }

    @Override
    protected void afterFetch(SearchEngineResponse response) {
        YahooDocumentSource.clean(response, this.keepHighlights, "title", "snippet");
    }
}

