/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.yahoo;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.carrot2.core.Document;
import org.carrot2.source.SearchEngineResponse;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class XMLResponseParser
implements ContentHandler {
    public SearchEngineResponse response;
    private Document document;
    private final ArrayList<String> stack = new ArrayList();
    private final StringBuilder buffer = new StringBuilder();
    private boolean error;
    private StringBuilder errorText;

    XMLResponseParser() {
    }

    public void startDocument() throws SAXException {
        this.error = false;
        this.response = null;
        this.stack.clear();
        this.cleanup();
    }

    private void cleanup() {
        this.document = null;
        this.buffer.setLength(0);
    }

    public void endDocument() throws SAXException {
        if (this.error) {
            throw new SAXException(new IOException("Yahoo! service error: " + this.errorText.toString()));
        }
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        this.buffer.setLength(0);
        if (this.stack.size() == 0 && "ResultSet".equals(localName)) {
            this.response = new SearchEngineResponse();
            XMLResponseParser.addResponseMetadataLong(attributes, "firstResultPosition", this.response, "firstIndex");
            XMLResponseParser.addResponseMetadataLong(attributes, "totalResultsAvailable", this.response, "resultsTotal");
            XMLResponseParser.addResponseMetadataLong(attributes, "totalResultsReturned", this.response, "resultsReturned");
        } else if (this.stack.size() == 0 && "Error".equals(localName)) {
            this.error = true;
            this.errorText = new StringBuilder();
        } else if (this.stack.size() > 1 && this.error) {
            this.errorText.append(localName + ": ");
        } else if ("Result".equals(localName)) {
            this.document = new Document();
        }
        this.stack.add(localName);
    }

    private static void addResponseMetadataLong(Attributes attributes, String attributeName, SearchEngineResponse response, String metadataKey) {
        String value = attributes.getValue(attributeName);
        if (value != null && !"".equals(value.trim())) {
            response.metadata.put(metadataKey, Long.parseLong(value));
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.error) {
            this.errorText.append((CharSequence)this.buffer);
            this.errorText.append("\n");
        } else if (this.stack.size() == 2 && "Result".equals(localName)) {
            this.response.results.add(this.document);
            this.cleanup();
        } else if (this.stack.size() == 3 && "Result".equals(this.stack.get(1))) {
            String text = StringEscapeUtils.unescapeHtml((String)this.buffer.toString());
            this.buffer.setLength(0);
            if ("Title".equals(localName)) {
                this.document.setField("title", text);
            } else if ("Summary".equals(localName)) {
                this.document.setField("snippet", text);
            } else if ("Url".equals(localName)) {
                this.document.setField("url", text);
            } else if ("NewsSource".equals(localName)) {
                this.document.setField("sources", Lists.newArrayList((Object[])new String[]{text}));
            } else if (!"Thumbnail".equals(localName)) {
                this.document.setField(localName, text);
            }
        } else if (this.stack.size() == 4 && "Thumbnail".equals(this.stack.get(2))) {
            String text = this.buffer.toString();
            this.buffer.setLength(0);
            if ("Url".equals(localName)) {
                this.document.setField("thumbnail-url", text);
            }
        }
        this.stack.remove(this.stack.size() - 1);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.buffer.append(chars, start, length);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void ignorableWhitespace(char[] whsp, int start, int length) throws SAXException {
    }

    public void processingInstruction(String name, String value) throws SAXException {
    }

    public void skippedEntity(String entity) throws SAXException {
    }
}

