/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipageSearchEngineDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.MultipageSearchEngine";
    public final String prefix = "";
    public final String title = "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    public final String label = "";
    public final String description = "This class implements helper methods for concurrent querying of search services that limit the number of search results returned in one request.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getTitle() {
        return "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "This class implements helper methods for concurrent querying of search services that limit the number of search results returned in one request.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends SearchEngineBaseDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder searchMode(MultipageSearchEngine.SearchMode value) {
            this.map.put("search-mode", (Object)value);
            return this;
        }

        public AttributeBuilder searchMode(Class<? extends MultipageSearchEngine.SearchMode> clazz) {
            this.map.put("search-mode", clazz);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo searchMode = new AttributeInfo("search-mode", "org.carrot2.source.MultipageSearchEngine", "searchMode", "Search mode defines how fetchers returned from {@link org.carrot2.source.MultipageSearchEngine#createFetcher}\nare called.", "Search Mode", "Search mode defines how fetchers returned from <code>org.carrot2.source.MultipageSearchEngine.createFetcher</code> are called", null, "Results paging", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends SearchEngineBaseDescriptor.Keys {
        public static final String SEARCH_MODE = "search-mode";

        protected Keys() {
        }
    }
}

