/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.nni;

import backport.api.edu.emory.mathcs.backport.java.util.Arrays;
import nni.LAPACK;
import org.carrot2.matrix.NNIDenseDoubleMatrix2D;
import org.carrot2.matrix.nni.ILapackOperations;

public final class LapackImpl
implements ILapackOperations {
    private static boolean initialized;

    private static synchronized void lazyInit() {
        if (initialized) {
            return;
        }
        LAPACK.init();
        initialized = true;
    }

    public LapackImpl() {
        LapackImpl.lazyInit();
    }

    public double[] computeEigenvaluesSymmetricalNNI(NNIDenseDoubleMatrix2D A) {
        double[] work = new double[1];
        int[] info = new int[1];
        int[] isuppz = new int[2 * Math.max(1, A.rows())];
        int[] iwork = new int[1];
        double abstol = LAPACK.lamch((char[])"Safe minimum".toCharArray());
        LAPACK.syevr((char[])new char[]{'N'}, (char[])new char[]{'A'}, (char[])new char[]{'L'}, (int[])new int[]{A.rows()}, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])new double[]{0.0}, (double[])new double[]{0.0}, (int[])new int[]{0}, (int[])new int[]{0}, (double[])new double[]{abstol}, (int[])new int[1], (double[])new double[0], (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (int[])isuppz, (double[])work, (int[])new int[]{-1}, (int[])iwork, (int[])new int[]{-1}, (int[])info);
        int lwork = 0;
        int liwork = 0;
        if (info[0] != 0) {
            lwork = 26 * A.rows();
            liwork = 10 * A.rows();
        } else {
            lwork = (int)work[0];
            liwork = iwork[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        work = new double[lwork];
        iwork = new int[liwork];
        double[] wr = new double[A.rows()];
        double[] data = A.getData();
        double[] dataA = Arrays.copyOf(data, data.length);
        LAPACK.syevr((char[])new char[]{'N'}, (char[])new char[]{'A'}, (char[])new char[]{'L'}, (int[])new int[]{A.rows()}, (double[])dataA, (int[])new int[]{Math.max(1, A.rows())}, (double[])new double[]{0.0}, (double[])new double[]{0.0}, (int[])new int[]{0}, (int[])new int[]{0}, (double[])new double[]{abstol}, (int[])new int[1], (double[])wr, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (int[])isuppz, (double[])work, (int[])new int[]{work.length}, (int[])iwork, (int[])new int[]{iwork.length}, (int[])info);
        return wr;
    }

    public double[] computeEigenvaluesNNI(NNIDenseDoubleMatrix2D A) {
        double[] work = new double[1];
        int[] info = new int[1];
        LAPACK.geev((char[])new char[]{'N'}, (char[])new char[]{'N'}, (int[])new int[]{A.rows()}, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])new double[0], (double[])new double[0], (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])work, (int[])new int[]{-1}, (int[])info);
        int lwork = 0;
        lwork = info[0] != 0 ? 3 * A.rows() : (int)work[0];
        lwork = Math.max(1, lwork);
        work = new double[lwork];
        double[] wr = new double[A.rows()];
        double[] wi = new double[A.rows()];
        double[] data = A.getData();
        double[] dataA = Arrays.copyOf(data, data.length);
        LAPACK.geev((char[])new char[]{'N'}, (char[])new char[]{'N'}, (int[])new int[]{A.rows()}, (double[])dataA, (int[])new int[]{Math.max(1, A.rows())}, (double[])wr, (double[])wi, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])new double[0], (int[])new int[]{Math.max(1, A.rows())}, (double[])work, (int[])new int[]{work.length}, (int[])info);
        return wr;
    }

    public void gesdd(char[] arg0, int[] arg1, int[] arg2, double[] arg3, int[] arg4, double[] arg5, double[] arg6, int[] arg7, double[] arg8, int[] arg9, double[] arg10, int[] arg11, int[] arg12, int[] arg13) {
        LAPACK.gesdd((char[])arg0, (int[])arg1, (int[])arg2, (double[])arg3, (int[])arg4, (double[])arg5, (double[])arg6, (int[])arg7, (double[])arg8, (int[])arg9, (double[])arg10, (int[])arg11, (int[])arg12, (int[])arg13);
    }
}

