/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import backport.api.edu.emory.mathcs.backport.java.util.Arrays;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.SingularValueDecomposition;
import org.carrot2.matrix.NNIDenseDoubleMatrix2D;
import org.carrot2.matrix.NNIDoubleFactory2D;
import org.carrot2.matrix.NNIInterface;
import org.carrot2.matrix.factorization.IMatrixFactorization;
import org.carrot2.matrix.factorization.MatrixFactorizationBase;

public class PartialSingularValueDecomposition
extends MatrixFactorizationBase
implements IMatrixFactorization {
    protected int k = -1;
    protected static final int DEFAULT_K = -1;
    private double[] work;
    private int[] iwork;
    private double[] S;

    public PartialSingularValueDecomposition(DoubleMatrix2D A) {
        super(A);
    }

    public void compute() {
        if (!NNIInterface.isNativeLapackAvailable() || !(this.A instanceof NNIDenseDoubleMatrix2D) || ((NNIDenseDoubleMatrix2D)this.A).isView()) {
            SingularValueDecomposition svd;
            if (this.A.columns() > this.A.rows()) {
                svd = new SingularValueDecomposition(this.A.viewDice());
                this.V = svd.getU();
                this.U = svd.getV();
            } else {
                svd = new SingularValueDecomposition(this.A);
                this.U = svd.getU();
                this.V = svd.getV();
            }
            this.S = svd.getSingularValues();
            if (this.k > 0 && this.k < this.S.length) {
                this.U = this.U.viewPart(0, 0, this.U.rows(), this.k);
                this.V = this.V.viewPart(0, 0, this.V.rows(), this.k);
                this.S = org.apache.mahout.math.Arrays.trimToCapacity((double[])this.S, (int)this.k);
            }
        } else {
            int n = this.A.rows();
            int m = this.A.columns();
            this.V = NNIDoubleFactory2D.nni.make(n, m);
            this.U = NNIDoubleFactory2D.nni.make(n, n);
            this.S = new double[Math.min(m, n)];
            this.init(m, n);
            double[] data = ((NNIDenseDoubleMatrix2D)this.A).getData();
            double[] dataA = Arrays.copyOf(data, data.length);
            int[] info = new int[1];
            NNIInterface.getLapack().gesdd(new char[]{'S'}, new int[]{m}, new int[]{n}, dataA, new int[]{Math.max(1, m)}, this.S, ((NNIDenseDoubleMatrix2D)this.V).getData(), new int[]{Math.max(1, m)}, ((NNIDenseDoubleMatrix2D)this.U).getData(), new int[]{Math.max(1, n)}, this.work, new int[]{this.work.length}, this.iwork, info);
            ((NNIDenseDoubleMatrix2D)this.V).transpose();
            if (this.k > 0 && this.k < this.S.length) {
                DenseDoubleMatrix2D Uk = (DenseDoubleMatrix2D)NNIDoubleFactory2D.nni.make(this.U.rows(), this.k);
                DenseDoubleMatrix2D Vk = (DenseDoubleMatrix2D)NNIDoubleFactory2D.nni.make(this.V.rows(), this.k);
                Uk.assign(this.U.viewPart(0, 0, this.U.rows(), this.k));
                Vk.assign(this.V.viewPart(0, 0, this.V.rows(), this.k));
                this.U = Uk;
                this.V = Vk;
                this.S = org.apache.mahout.math.Arrays.trimToCapacity((double[])this.S, (int)this.k);
            }
        }
    }

    private void init(int m, int n) {
        this.iwork = new int[8 * Math.min(m, n)];
        this.work = new double[1];
        int[] info = new int[1];
        NNIInterface.getLapack().gesdd(new char[]{'S'}, new int[]{m}, new int[]{n}, new double[0], new int[]{Math.max(1, m)}, new double[0], new double[0], new int[]{Math.max(1, m)}, new double[0], new int[]{Math.max(1, n)}, this.work, new int[]{-1}, this.iwork, info);
        int lwork = -1;
        lwork = info[0] != 0 ? 3 * Math.min(m, n) * Math.min(m, n) + Math.max(Math.max(m, n), 4 * Math.min(m, n) * Math.min(m, n) + 4 * Math.min(m, n)) : (int)this.work[0];
        lwork = Math.max(lwork, 1);
        this.work = new double[lwork];
    }

    public String toString() {
        return "nni-SVD";
    }

    public double[] getSingularValues() {
        return this.S;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }
}

