/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uima.processor.ae;

import java.net.URL;
import java.util.Map;
import org.apache.solr.uima.processor.ae.AEProvider;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverridingParamsAEProvider
implements AEProvider {
    private static Logger log = LoggerFactory.getLogger(OverridingParamsAEProvider.class);
    private String aeFilePath;
    private AnalysisEngine cachedAE;
    private Map<String, Object> runtimeParameters;

    public OverridingParamsAEProvider(String aeFilePath, Map<String, Object> runtimeParameters) {
        this.aeFilePath = aeFilePath;
        this.runtimeParameters = runtimeParameters;
    }

    @Override
    public synchronized AnalysisEngine getAE() throws ResourceInitializationException {
        try {
            if (this.cachedAE == null) {
                URL url = this.getClass().getResource(this.aeFilePath);
                XMLInputSource in = new XMLInputSource(url);
                AnalysisEngineDescription desc = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
                for (String attributeName : this.runtimeParameters.keySet()) {
                    Object val = this.getRuntimeValue(desc, attributeName);
                    desc.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue(attributeName, val);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("setting " + attributeName + " : " + this.runtimeParameters.get(attributeName));
                }
                this.cachedAE = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)desc);
                if (log.isDebugEnabled()) {
                    log.debug("AE " + this.cachedAE.getAnalysisEngineMetaData().getName() + " created from descriptor " + this.aeFilePath);
                }
            } else {
                this.cachedAE.reconfigure();
                if (log.isDebugEnabled()) {
                    log.debug("AE " + this.cachedAE.getAnalysisEngineMetaData().getName() + " at path " + this.aeFilePath + " reconfigured ");
                }
            }
        }
        catch (Exception e) {
            this.cachedAE = null;
            throw new ResourceInitializationException((Throwable)e);
        }
        return this.cachedAE;
    }

    private Object getRuntimeValue(AnalysisEngineDescription desc, String attributeName) throws ClassNotFoundException {
        String type = desc.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().getConfigurationParameter(null, attributeName).getType();
        Object val = null;
        Object runtimeValue = this.runtimeParameters.get(attributeName);
        if (runtimeValue != null) {
            if ("String".equals(type)) {
                val = String.valueOf(runtimeValue);
            } else if ("Integer".equals(type)) {
                val = Integer.valueOf(runtimeValue.toString());
            } else if ("Boolean".equals(type)) {
                val = Boolean.valueOf(runtimeValue.toString());
            } else if ("Float".equals(type)) {
                val = Float.valueOf(runtimeValue.toString());
            }
        }
        return val;
    }
}

