/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultNotSupportedException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.cas.CAS;
import org.apache.uima.internal.util.AnalysisEnginePool;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiprocessingAnalysisEngine_impl
extends AnalysisEngineImplBase
implements TextAnalysisEngine {
    private AnalysisEnginePool mPool;
    private static int DEFAULT_NUM_SIMULTANEOUS_REQUESTS = 3;
    private static int DEFAULT_TIMEOUT_PERIOD = 0;
    private int mTimeout;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        super.initialize(aSpecifier, aAdditionalParams);
        aAdditionalParams = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
        Integer poolSizeInteger = (Integer)aAdditionalParams.get("NUM_SIMULTANEOUS_REQUESTS");
        int poolSize = poolSizeInteger != null ? poolSizeInteger : DEFAULT_NUM_SIMULTANEOUS_REQUESTS;
        Integer timeoutInteger = (Integer)aAdditionalParams.get("TIMEOUT_PERIOD");
        this.mTimeout = timeoutInteger != null ? timeoutInteger : DEFAULT_TIMEOUT_PERIOD;
        aAdditionalParams.put("UIMA_CONTEXT", this.getUimaContextAdmin());
        aAdditionalParams.remove("NUM_SIMULTANEOUS_REQUESTS");
        this.mPool = new AnalysisEnginePool("", poolSize, aSpecifier, aAdditionalParams);
        this.setMetaData(this.mPool.getMetaData());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessTrace process(CAS aCAS, ResultSpecification aResultSpec) throws ResultNotSupportedException, AnalysisEngineProcessException {
        AnalysisEngine ae = null;
        try {
            ae = this.mPool.getAnalysisEngine(this.mTimeout);
            if (ae == null) {
                throw new AnalysisEngineProcessException("timeout_elapsed", new Object[]{this.getTimeout()});
            }
            ProcessTrace processTrace = ae.process(aCAS, aResultSpec);
            return processTrace;
        }
        finally {
            if (ae != null) {
                this.mPool.releaseAnalysisEngine(ae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CAS aCAS, ResultSpecification aResultSpec, ProcessTrace aTrace) throws ResultNotSupportedException, AnalysisEngineProcessException {
        AnalysisEngine ae = null;
        try {
            ae = this.mPool.getAnalysisEngine(this.mTimeout);
            if (ae == null) {
                throw new AnalysisEngineProcessException("timeout_elapsed", new Object[]{this.getTimeout()});
            }
            ae.process(aCAS, aResultSpec);
            this.buildProcessTraceFromMBeanStats(aTrace);
        }
        finally {
            if (ae != null) {
                this.mPool.releaseAnalysisEngine(ae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        this.enterProcess();
        AnalysisEngine ae = null;
        try {
            ae = this.mPool.getAnalysisEngine(this.mTimeout);
            if (ae == null) {
                throw new AnalysisEngineProcessException("timeout_elapsed", new Object[]{this.getTimeout()});
            }
            CasIterator casIterator = ae.processAndOutputNewCASes(aCAS);
            return casIterator;
        }
        finally {
            if (ae != null) {
                this.mPool.releaseAnalysisEngine(ae);
            }
            this.exitProcess();
        }
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
        this.mPool.setResultSpecification(aResultSpec);
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        this.mPool.reconfigure();
    }

    @Override
    public void destroy() {
        this.mPool.destroy();
        super.destroy();
    }

    @Override
    public void setLogger(Logger aLogger) {
        super.setLogger(aLogger);
        this.mPool.setLogger(aLogger);
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.mPool.batchProcessComplete();
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.mPool.collectionProcessComplete();
    }

    protected AnalysisEnginePool getPool() {
        return this.mPool;
    }

    protected int getTimeout() {
        return this.mTimeout;
    }
}

