/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.TagExtractor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TagExtractorTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testTagExtractor() {
        TagExtractor tagExtractor = new TagExtractor(null, 0);
        Assert.assertEquals((Object)tagExtractor.target_, null);
        Assert.assertEquals((long)tagExtractor.threshold_, (long)0L);
        TagExtractor tagExtractor2 = new TagExtractor("abstract", 10);
        Assert.assertEquals((Object)tagExtractor2.target_, (Object)"abstract");
        Assert.assertEquals((long)tagExtractor2.threshold_, (long)10L);
    }

    @Test
    public final void testSetTag() {
        TagExtractor tagExtractor = new TagExtractor(null, 0);
        tagExtractor.setTag("");
        Assert.assertEquals((Object)tagExtractor.tag_, (Object)"");
        tagExtractor.setTag(null);
        Assert.assertEquals((Object)tagExtractor.tag_, null);
    }

    @Test
    public final void testAdd() {
        TagExtractor tagExtractor = new TagExtractor(null, 0);
        tagExtractor.add("");
        tagExtractor.add(null);
    }

    @Test
    public final void testCloseTag() {
        TagExtractor tagExtractor = new TagExtractor(null, 0);
        LangProfile langProfile = null;
        tagExtractor.closeTag(langProfile);
    }

    @Test
    public final void testNormalScenario() {
        TagExtractor tagExtractor = new TagExtractor("abstract", 10);
        Assert.assertEquals((long)tagExtractor.count(), (long)0L);
        LangProfile langProfile = new LangProfile("en");
        tagExtractor.setTag("abstract");
        tagExtractor.add("This is a sample text.");
        tagExtractor.closeTag(langProfile);
        Assert.assertEquals((long)tagExtractor.count(), (long)1L);
        Assert.assertEquals((long)langProfile.n_words[0], (long)17L);
        Assert.assertEquals((long)langProfile.n_words[1], (long)22L);
        Assert.assertEquals((long)langProfile.n_words[2], (long)17L);
        tagExtractor.setTag("abstract");
        tagExtractor.add("sample");
        tagExtractor.closeTag(langProfile);
        Assert.assertEquals((long)tagExtractor.count(), (long)1L);
        tagExtractor.setTag("div");
        tagExtractor.add("This is a sample text which is enough long.");
        tagExtractor.closeTag(langProfile);
        Assert.assertEquals((long)tagExtractor.count(), (long)1L);
    }

    @Test
    public final void testClear() {
        TagExtractor tagExtractor = new TagExtractor("abstract", 10);
        tagExtractor.setTag("abstract");
        tagExtractor.add("This is a sample text.");
        Assert.assertEquals((Object)tagExtractor.buf_.toString(), (Object)"This is a sample text.");
        Assert.assertEquals((Object)tagExtractor.tag_, (Object)"abstract");
        tagExtractor.clear();
        Assert.assertEquals((Object)tagExtractor.buf_.toString(), (Object)"");
        Assert.assertEquals((Object)tagExtractor.tag_, null);
    }
}

