/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.NGram;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NGramTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testConstants() {
        Assert.assertThat((Object)3, (Matcher)CoreMatchers.is((Object)3));
        Assert.assertEquals((long)3L, (long)3L);
    }

    @Test
    public final void testNormalizeWithLatin() {
        Assert.assertEquals((long)NGram.normalize('\u0000'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\t'), (long)32L);
        Assert.assertEquals((long)NGram.normalize(' '), (long)32L);
        Assert.assertEquals((long)NGram.normalize('0'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('@'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('A'), (long)65L);
        Assert.assertEquals((long)NGram.normalize('Z'), (long)90L);
        Assert.assertEquals((long)NGram.normalize('['), (long)32L);
        Assert.assertEquals((long)NGram.normalize('`'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('a'), (long)97L);
        Assert.assertEquals((long)NGram.normalize('z'), (long)122L);
        Assert.assertEquals((long)NGram.normalize('{'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u007f'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u0080'), (long)128L);
        Assert.assertEquals((long)NGram.normalize('\u00a0'), (long)32L);
        Assert.assertEquals((long)NGram.normalize('\u00a1'), (long)161L);
    }

    @Test
    public final void testNormalizeWithCJKKanji() {
        Assert.assertEquals((long)NGram.normalize('\u4e00'), (long)19968L);
        Assert.assertEquals((long)NGram.normalize('\u4e01'), (long)19969L);
        Assert.assertEquals((long)NGram.normalize('\u4e02'), (long)19970L);
        Assert.assertEquals((long)NGram.normalize('\u4e03'), (long)19969L);
        Assert.assertEquals((long)NGram.normalize('\u4e04'), (long)19972L);
        Assert.assertEquals((long)NGram.normalize('\u4e05'), (long)19973L);
        Assert.assertEquals((long)NGram.normalize('\u4e06'), (long)19974L);
        Assert.assertEquals((long)NGram.normalize('\u4e07'), (long)19975L);
        Assert.assertEquals((long)NGram.normalize('\u4e08'), (long)19976L);
        Assert.assertEquals((long)NGram.normalize('\u4e09'), (long)19977L);
        Assert.assertEquals((long)NGram.normalize('\u4e10'), (long)19984L);
        Assert.assertEquals((long)NGram.normalize('\u4e11'), (long)19985L);
        Assert.assertEquals((long)NGram.normalize('\u4e12'), (long)19986L);
        Assert.assertEquals((long)NGram.normalize('\u4e13'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e14'), (long)19988L);
        Assert.assertEquals((long)NGram.normalize('\u4e15'), (long)19989L);
        Assert.assertEquals((long)NGram.normalize('\u4e1e'), (long)19998L);
        Assert.assertEquals((long)NGram.normalize('\u4e1f'), (long)19999L);
        Assert.assertEquals((long)NGram.normalize('\u4e20'), (long)20000L);
        Assert.assertEquals((long)NGram.normalize('\u4e21'), (long)20001L);
        Assert.assertEquals((long)NGram.normalize('\u4e22'), (long)20002L);
        Assert.assertEquals((long)NGram.normalize('\u4e23'), (long)20003L);
        Assert.assertEquals((long)NGram.normalize('\u4e24'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e25'), (long)19987L);
        Assert.assertEquals((long)NGram.normalize('\u4e30'), (long)20016L);
    }

    @Test
    public final void testNGram() {
        NGram nGram = new NGram();
        Assert.assertEquals((Object)nGram.get(0), null);
        Assert.assertEquals((Object)nGram.get(1), null);
        Assert.assertEquals((Object)nGram.get(2), null);
        Assert.assertEquals((Object)nGram.get(3), null);
        Assert.assertEquals((Object)nGram.get(4), null);
        nGram.addChar(' ');
        Assert.assertEquals((Object)nGram.get(1), null);
        Assert.assertEquals((Object)nGram.get(2), null);
        Assert.assertEquals((Object)nGram.get(3), null);
        nGram.addChar('A');
        Assert.assertEquals((Object)nGram.get(1), (Object)"A");
        Assert.assertEquals((Object)nGram.get(2), (Object)" A");
        Assert.assertEquals((Object)nGram.get(3), null);
        nGram.addChar('\u06cc');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\u064a");
        Assert.assertEquals((Object)nGram.get(2), (Object)"A\u064a");
        Assert.assertEquals((Object)nGram.get(3), (Object)" A\u064a");
        nGram.addChar('\u1ea0');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\u1ec3");
        Assert.assertEquals((Object)nGram.get(2), (Object)"\u064a\u1ec3");
        Assert.assertEquals((Object)nGram.get(3), (Object)"A\u064a\u1ec3");
        nGram.addChar('\u3044');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\u3042");
        Assert.assertEquals((Object)nGram.get(2), (Object)"\u1ec3\u3042");
        Assert.assertEquals((Object)nGram.get(3), (Object)"\u064a\u1ec3\u3042");
        nGram.addChar('\u30a4');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\u30a2");
        Assert.assertEquals((Object)nGram.get(2), (Object)"\u3042\u30a2");
        Assert.assertEquals((Object)nGram.get(3), (Object)"\u1ec3\u3042\u30a2");
        nGram.addChar('\u3106');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\u3105");
        Assert.assertEquals((Object)nGram.get(2), (Object)"\u30a2\u3105");
        Assert.assertEquals((Object)nGram.get(3), (Object)"\u3042\u30a2\u3105");
        nGram.addChar('\uac01');
        Assert.assertEquals((Object)nGram.get(1), (Object)"\uac00");
        Assert.assertEquals((Object)nGram.get(2), (Object)"\u3105\uac00");
        Assert.assertEquals((Object)nGram.get(3), (Object)"\u30a2\u3105\uac00");
        nGram.addChar('\u2010');
        Assert.assertEquals((Object)nGram.get(1), null);
        Assert.assertEquals((Object)nGram.get(2), (Object)"\uac00 ");
        Assert.assertEquals((Object)nGram.get(3), (Object)"\u3105\uac00 ");
        nGram.addChar('a');
        Assert.assertEquals((Object)nGram.get(1), (Object)"a");
        Assert.assertEquals((Object)nGram.get(2), (Object)" a");
        Assert.assertEquals((Object)nGram.get(3), null);
    }
}

