/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.LangProfile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LangProfileTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testLangProfile() {
        LangProfile langProfile = new LangProfile();
        Assert.assertEquals((Object)langProfile.name, null);
    }

    @Test
    public final void testLangProfileStringInt() {
        LangProfile langProfile = new LangProfile("en");
        Assert.assertEquals((Object)langProfile.name, (Object)"en");
    }

    @Test
    public final void testAdd() {
        LangProfile langProfile = new LangProfile("en");
        langProfile.add("a");
        Assert.assertEquals((long)langProfile.freq.get("a").intValue(), (long)1L);
        langProfile.add("a");
        Assert.assertEquals((long)langProfile.freq.get("a").intValue(), (long)2L);
        langProfile.omitLessFreq();
    }

    @Test
    public final void testAddIllegally1() {
        LangProfile langProfile = new LangProfile();
        langProfile.add("a");
        Assert.assertEquals((Object)langProfile.freq.get("a"), null);
    }

    @Test
    public final void testAddIllegally2() {
        LangProfile langProfile = new LangProfile("en");
        langProfile.add("a");
        langProfile.add("");
        langProfile.add("abcd");
        Assert.assertEquals((long)langProfile.freq.get("a").intValue(), (long)1L);
        Assert.assertEquals((Object)langProfile.freq.get(""), null);
        Assert.assertEquals((Object)langProfile.freq.get("abcd"), null);
    }

    @Test
    public final void testOmitLessFreq() {
        LangProfile langProfile = new LangProfile("en");
        String[] stringArray = "a b c \u3042 \u3044 \u3046 \u3048 \u304a \u304b \u304c \u304d \u304e \u304f".split(" ");
        for (int i = 0; i < 5; ++i) {
            for (String string : stringArray) {
                langProfile.add(string);
            }
        }
        langProfile.add("\u3050");
        Assert.assertEquals((long)langProfile.freq.get("a").intValue(), (long)5L);
        Assert.assertEquals((long)langProfile.freq.get("\u3042").intValue(), (long)5L);
        Assert.assertEquals((long)langProfile.freq.get("\u3050").intValue(), (long)1L);
        langProfile.omitLessFreq();
        Assert.assertEquals((Object)langProfile.freq.get("a"), null);
        Assert.assertEquals((long)langProfile.freq.get("\u3042").intValue(), (long)5L);
        Assert.assertEquals((Object)langProfile.freq.get("\u3050"), null);
    }

    @Test
    public final void testOmitLessFreqIllegally() {
        LangProfile langProfile = new LangProfile();
        langProfile.omitLessFreq();
    }
}

