/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;
import com.cybozu.labs.langdetect.util.TagExtractor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GenProfile {
    public static LangProfile loadFromWikipediaAbstract(String string, File file) throws LangDetectException {
        LangProfile langProfile = new LangProfile(string);
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            TagExtractor tagExtractor = new TagExtractor("abstract", 100);
            XMLStreamReader xMLStreamReader = null;
            try {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                xMLStreamReader = xMLInputFactory.createXMLStreamReader(inputStream);
                while (xMLStreamReader.hasNext()) {
                    switch (xMLStreamReader.next()) {
                        case 1: {
                            tagExtractor.setTag(xMLStreamReader.getName().toString());
                            break;
                        }
                        case 4: {
                            tagExtractor.add(xMLStreamReader.getText());
                            break;
                        }
                        case 2: {
                            tagExtractor.closeTag(langProfile);
                        }
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new LangDetectException(ErrorCode.TrainDataFormatError, "Training database file '" + file.getName() + "' is an invalid XML.");
            }
            finally {
                try {
                    if (xMLStreamReader != null) {
                        xMLStreamReader.close();
                    }
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            System.out.println(string + ":" + tagExtractor.count());
        }
        catch (IOException iOException) {
            throw new LangDetectException(ErrorCode.CantOpenTrainData, "Can't open training database file '" + file.getName() + "'");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return langProfile;
    }

    public static LangProfile loadFromText(String string, File file) throws LangDetectException {
        LangProfile langProfile = new LangProfile(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            int n = 0;
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                NGram nGram = new NGram();
                for (int i = 0; i < string2.length(); ++i) {
                    nGram.addChar(string2.charAt(i));
                    for (int j = 1; j <= 3; ++j) {
                        langProfile.add(nGram.get(j));
                    }
                }
                ++n;
            }
            System.out.println(string + ":" + n);
        }
        catch (IOException iOException) {
            throw new LangDetectException(ErrorCode.CantOpenTrainData, "Can't open training database file '" + file.getName() + "'");
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return langProfile;
    }
}

