/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DetectorTest {
    private static final String TRAINING_EN = "a a a b b c c d e";
    private static final String TRAINING_FR = "a b b c c c d d d";
    private static final String TRAINING_JA = "\u3042 \u3042 \u3042 \u3044 \u3046 \u3048 \u3048";
    private static final String JSON_LANG1 = "{\"freq\":{\"A\":3,\"B\":6,\"C\":3,\"AB\":2,\"BC\":1,\"ABC\":2,\"BBC\":1,\"CBA\":1},\"n_words\":[12,3,4],\"name\":\"lang1\"}";
    private static final String JSON_LANG2 = "{\"freq\":{\"A\":6,\"B\":3,\"C\":3,\"AA\":3,\"AB\":2,\"ABC\":1,\"ABA\":1,\"CAA\":1},\"n_words\":[12,5,3],\"name\":\"lang2\"}";

    @Before
    public void setUp() throws Exception {
        DetectorFactory.clear();
        LangProfile langProfile = new LangProfile("en");
        for (String string : TRAINING_EN.split(" ")) {
            langProfile.add(string);
        }
        DetectorFactory.addProfile(langProfile, 0, 3);
        LangProfile langProfile2 = new LangProfile("fr");
        for (String string : TRAINING_FR.split(" ")) {
            langProfile2.add(string);
        }
        DetectorFactory.addProfile(langProfile2, 1, 3);
        LangProfile langProfile3 = new LangProfile("ja");
        for (String string : TRAINING_JA.split(" ")) {
            langProfile3.add(string);
        }
        DetectorFactory.addProfile(langProfile3, 2, 3);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testDetector1() throws LangDetectException {
        Detector detector = DetectorFactory.create();
        detector.append("a");
        Assert.assertEquals((Object)detector.detect(), (Object)"en");
    }

    @Test
    public final void testDetector2() throws LangDetectException {
        Detector detector = DetectorFactory.create();
        detector.append("b d");
        Assert.assertEquals((Object)detector.detect(), (Object)"fr");
    }

    @Test
    public final void testDetector3() throws LangDetectException {
        Detector detector = DetectorFactory.create();
        detector.append("d e");
        Assert.assertEquals((Object)detector.detect(), (Object)"en");
    }

    @Test
    public final void testDetector4() throws LangDetectException {
        Detector detector = DetectorFactory.create();
        detector.append("\u3042\u3042\u3042\u3042a");
        Assert.assertEquals((Object)detector.detect(), (Object)"ja");
    }

    @Test
    public final void testLangList() throws LangDetectException {
        List<String> list = DetectorFactory.getLangList();
        Assert.assertEquals((long)list.size(), (long)3L);
        Assert.assertEquals((Object)list.get(0), (Object)"en");
        Assert.assertEquals((Object)list.get(1), (Object)"fr");
        Assert.assertEquals((Object)list.get(2), (Object)"ja");
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void testLangListException() throws LangDetectException {
        List<String> list = DetectorFactory.getLangList();
        list.add("hoge");
    }

    @Test
    public final void testFactoryFromJsonString() throws LangDetectException {
        DetectorFactory.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(JSON_LANG1);
        arrayList.add(JSON_LANG2);
        DetectorFactory.loadProfile(arrayList);
        List<String> list = DetectorFactory.getLangList();
        Assert.assertEquals((long)list.size(), (long)2L);
        Assert.assertEquals((Object)list.get(0), (Object)"lang1");
        Assert.assertEquals((Object)list.get(1), (Object)"lang2");
    }
}

