/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.util.ExternalPaths;
import org.junit.AfterClass;

public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    public static JettySolrRunner jetty;
    public static int port;
    public static SolrServer server;
    public static String context;

    public String getSolrHome() {
        return ExternalPaths.EXAMPLE_HOME;
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String context) throws Exception {
        SolrJettyTestBase.initCore(null, null, solrHome);
        SolrJettyTestBase.ignoreException("maxWarmingSearchers");
        System.setProperty("solr.solr.home", solrHome);
        System.setProperty("solr.data.dir", dataDir.getCanonicalPath());
        System.setProperty("solr.velocity.enabled", "false");
        SolrJettyTestBase.context = context = context == null ? "/solr" : context;
        jetty = new JettySolrRunner(context, 0, configFile);
        jetty.start();
        port = jetty.getLocalPort();
        log.info("Jetty Assigned Port#" + port);
        return jetty;
    }

    @AfterClass
    public static void afterSolrJettyTestBase() throws Exception {
        if (jetty != null) {
            jetty.stop();
            jetty = null;
        }
        server = null;
    }

    public SolrServer getSolrServer() {
        if (server == null) {
            server = this.createNewSolrServer();
        }
        return server;
    }

    public SolrServer createNewSolrServer() {
        if (jetty != null) {
            try {
                String url = "http://localhost:" + port + context;
                CommonsHttpSolrServer s = new CommonsHttpSolrServer(url);
                s.setConnectionTimeout(100);
                s.setDefaultMaxConnectionsPerHost(100);
                s.setMaxTotalConnections(100);
                return s;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EmbeddedSolrServer(h.getCoreContainer(), "");
    }
}

