/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortFloatProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractShortFloatMap
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final float value) {
        return !this.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short iterKey, float iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortFloatMap copy() {
        return (AbstractShortFloatMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortFloatMap)) {
            return false;
        }
        final AbstractShortFloatMap other = (AbstractShortFloatMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short key, float value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short key, float value) {
                return AbstractShortFloatMap.this.containsKey(key) && AbstractShortFloatMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortFloatProcedure procedure) {
        return this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortFloatMap.this.get(key));
            }
        });
    }

    public abstract float get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final ShortFloatProcedure condition, final ShortArrayList keyList, final FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short key, float value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] k = keyList.elements();
        final float[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                float t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, float var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public FloatArrayList values() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            public boolean apply(short key) {
                list.add(AbstractShortFloatMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final FloatFunction function) {
        this.copy().forEachPair(new ShortFloatProcedure(){

            public boolean apply(short key, float value) {
                AbstractShortFloatMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractShortFloatMap other) {
        this.clear();
        other.forEachPair(new ShortFloatProcedure(){

            public boolean apply(short key, float value) {
                AbstractShortFloatMap.this.put(key, value);
                return true;
            }
        });
    }

    public float adjustOrPutValue(short key, float newValue, float incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

