/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.buffer;

import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.buffer.DoubleBuffer3DConsumer;
import org.apache.mahout.math.list.DoubleArrayList;

@Deprecated
public class DoubleBuffer3D
extends PersistentObject
implements DoubleBuffer3DConsumer {
    private final DoubleBuffer3DConsumer target;
    private final double[] xElements;
    private final double[] yElements;
    private final double[] zElements;
    private final DoubleArrayList xList;
    private final DoubleArrayList yList;
    private final DoubleArrayList zList;
    private final int capacity;
    private int size;

    public DoubleBuffer3D(DoubleBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new double[capacity];
        this.yElements = new double[capacity];
        this.zElements = new double[capacity];
        this.xList = new DoubleArrayList(this.xElements);
        this.yList = new DoubleArrayList(this.yElements);
        this.zList = new DoubleArrayList(this.zElements);
        this.size = 0;
    }

    public void add(double x, double y, double z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    public void addAllOf(DoubleArrayList xElements, DoubleArrayList yElements, DoubleArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

