/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.IntIntDoubleFunction;
import org.apache.mahout.math.function.Mult;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix1D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.RCDoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.SparseDoubleMatrix1D;
import org.apache.mahout.math.matrix.impl.SparseDoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.WrapperDoubleMatrix2D;

class TridiagonalDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private final double[] values;
    private final int[] dims;
    private static final int NONZERO = 4;

    TridiagonalDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    TridiagonalDoubleMatrix2D(int rows, int columns) {
        super(null);
        this.setUp(rows, columns);
        int d = Math.min(rows, columns);
        int u = d - 1;
        int l = d - 1;
        if (rows > columns) {
            ++l;
        }
        if (rows < columns) {
            ++u;
        }
        this.values = new double[l + d + u];
        this.dims = new int[]{0, l, l + d, l + d + u, 0, 0, 0};
    }

    public DoubleMatrix2D assign(double value) {
        if (value == 0.0) {
            int i = this.values.length;
            while (--i >= 0) {
                this.values[i] = 0.0;
            }
            i = this.dims.length;
            while (--i >= 4) {
                this.dims[i] = 0;
            }
        } else {
            super.assign(value);
        }
        return this;
    }

    public DoubleMatrix2D assign(final UnaryFunction function) {
        if (function instanceof Mult) {
            double alpha = ((Mult)function).getMultiplicator();
            if (alpha == 1.0) {
                return this;
            }
            if (alpha == 0.0) {
                return this.assign(0.0);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    return function.apply(value);
                }
            });
        } else {
            super.assign(function);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof TridiagonalDoubleMatrix2D) {
            TridiagonalDoubleMatrix2D other = (TridiagonalDoubleMatrix2D)source;
            System.arraycopy(other.values, 0, this.values, 0, this.values.length);
            System.arraycopy(other.dims, 0, this.dims, 0, this.dims.length);
            return this;
        }
        if (source instanceof RCDoubleMatrix2D || source instanceof SparseDoubleMatrix2D) {
            this.assign(0.0);
            source.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    TridiagonalDoubleMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
            return this;
        }
        return super.assign(source);
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D y, BinaryFunction function) {
        this.checkShape(y);
        if (function instanceof PlusMult) {
            final double alpha = ((PlusMult)function).getMultiplicator();
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    TridiagonalDoubleMatrix2D.this.setQuick(i, j, TridiagonalDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function == Functions.mult) {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    TridiagonalDoubleMatrix2D.this.setQuick(i, j, TridiagonalDoubleMatrix2D.this.getQuick(i, j) * y.getQuick(i, j));
                    return value;
                }
            });
            return this;
        }
        if (function == Functions.div) {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double value) {
                    TridiagonalDoubleMatrix2D.this.setQuick(i, j, TridiagonalDoubleMatrix2D.this.getQuick(i, j) / y.getQuick(i, j));
                    return value;
                }
            });
            return this;
        }
        return super.assign(y, function);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        for (int kind = 0; kind <= 2; ++kind) {
            int i = 0;
            int j = 0;
            switch (kind) {
                case 0: {
                    i = 1;
                }
                case 2: {
                    j = 1;
                }
            }
            int low = this.dims[kind];
            int high = this.dims[kind + 1];
            int k = low;
            while (k < high) {
                double r;
                double value = this.values[k];
                if (value != 0.0 && (r = function.apply(i, j, value)) != value) {
                    if (r == 0.0) {
                        int n = kind + 4;
                        this.dims[n] = this.dims[n] + 1;
                    }
                    this.values[k] = r;
                }
                ++k;
                ++i;
                ++j;
            }
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public double getQuick(int row, int column) {
        int i = row;
        int j = column;
        int k = j - i + 1;
        int q = i;
        if (k == 0) {
            q = j;
        }
        if (k >= 0 && k <= 2) {
            return this.values[this.dims[k] + q];
        }
        return 0.0;
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return new TridiagonalDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    public void setQuick(int row, int column, double value) {
        int i = row;
        int j = column;
        boolean isZero = value == 0.0;
        int k = j - i + 1;
        int q = i;
        if (k == 0) {
            q = j;
        }
        if (k >= 0 && k <= 2) {
            int index = this.dims[k] + q;
            if (this.values[index] != 0.0) {
                if (isZero) {
                    int n = k + 4;
                    this.dims[n] = this.dims[n] - 1;
                }
            } else if (!isZero) {
                int n = k + 4;
                this.dims[n] = this.dims[n] + 1;
            }
            this.values[index] = value;
            return;
        }
        if (!isZero) {
            throw new IllegalArgumentException("Can't store non-zero value to non-tridiagonal coordinate: row=" + row + ", column=" + column + ", value=" + value);
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, final boolean transposeA) {
        boolean ignore;
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseDoubleMatrix1D(m);
        }
        if (!(this.isNoView && y instanceof DenseDoubleMatrix1D && z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if (n != y.size() || m > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore) {
            z.assign(Functions.mult(beta / alpha));
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        final double[] zElements = zz.elements;
        final int zStride = zz.stride;
        final int zi = z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        final double[] yElements = yy.elements;
        final int yStride = yy.stride;
        final int yi = y.index(0);
        if (yElements == null || zElements == null) {
            throw new InternalError();
        }
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double value) {
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zi + zStride * i;
                zElements[n] = zElements[n] + value * yElements[yi + yStride * j];
                return value;
            }
        });
        if (alpha != 1.0) {
            z.assign(Functions.mult(alpha));
        }
        return z;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, double beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (transposeB) {
            B = B.viewDice();
        }
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        int p = B.columns;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseDoubleMatrix2D(m, p);
        }
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows != m || C.columns != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(Functions.mult(beta));
        }
        final DoubleMatrix1D[] Brows = new DoubleMatrix1D[n];
        int i = n;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final DoubleMatrix1D[] Crows = new DoubleMatrix1D[m];
        int i2 = m;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final PlusMult fun = PlusMult.plusMult(0.0);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double value) {
                fun.setMultiplicator(value * alpha);
                if (!transposeA) {
                    Crows[i].assign(Brows[j], fun);
                } else {
                    Crows[j].assign(Brows[i], fun);
                }
                return value;
            }
        });
        return C;
    }
}

