/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat.quantile;

import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.random.sampling.RandomSamplingAssistant;
import org.apache.mahout.math.jet.stat.quantile.DoubleBuffer;
import org.apache.mahout.math.jet.stat.quantile.DoubleQuantileEstimator;
import org.apache.mahout.math.list.DoubleArrayList;

class KnownDoubleQuantileEstimator
extends DoubleQuantileEstimator {
    protected double beta;
    protected boolean weHadMoreThanOneEmptyBuffer;
    protected RandomSamplingAssistant samplingAssistant;
    protected final double samplingRate;
    protected final long N;

    KnownDoubleQuantileEstimator(int b, int k, long N, double samplingRate, RandomEngine generator) {
        this.samplingRate = samplingRate;
        this.N = N;
        this.samplingAssistant = this.samplingRate <= 1.0 ? null : new RandomSamplingAssistant(Arithmetic.floor((double)N / samplingRate), N, generator);
        this.setUp(b, k);
        this.clear();
    }

    protected void addInfinities(int missingInfinities, DoubleBuffer buffer) {
        RandomSamplingAssistant oldAssistant = this.samplingAssistant;
        this.samplingAssistant = null;
        boolean even = true;
        for (int i = 0; i < missingInfinities; ++i) {
            if (even) {
                buffer.values.add(Double.MAX_VALUE);
            } else {
                buffer.values.add(-1.7976931348623157E308);
            }
            even = !even;
        }
        this.samplingAssistant = oldAssistant;
    }

    protected DoubleBuffer[] buffersToCollapse() {
        int minLevel = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    public void clear() {
        super.clear();
        this.beta = 1.0;
        this.weHadMoreThanOneEmptyBuffer = false;
        RandomSamplingAssistant assist = this.samplingAssistant;
        if (assist != null) {
            this.samplingAssistant = new RandomSamplingAssistant(Arithmetic.floor((double)this.N / this.samplingRate), this.N, assist.getRandomGenerator());
        }
    }

    public Object clone() {
        KnownDoubleQuantileEstimator copy = (KnownDoubleQuantileEstimator)super.clone();
        if (this.samplingAssistant != null) {
            copy.samplingAssistant = (RandomSamplingAssistant)((Object)copy.samplingAssistant.clone());
        }
        return copy;
    }

    protected void newBuffer() {
        int numberOfEmptyBuffers = this.bufferSet._getNumberOfEmptyBuffers();
        if (numberOfEmptyBuffers == 0) {
            throw new IllegalStateException("Oops, no empty buffer.");
        }
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (numberOfEmptyBuffers == 1 && !this.weHadMoreThanOneEmptyBuffer) {
            this.currentBufferToFill.level(this.bufferSet._getMinLevelOfFullOrPartialBuffers());
        } else {
            this.weHadMoreThanOneEmptyBuffer = true;
            this.currentBufferToFill.level(0);
        }
        this.currentBufferToFill.weight(1);
    }

    protected void postCollapse(DoubleBuffer[] toCollapse) {
        this.weHadMoreThanOneEmptyBuffer = false;
    }

    protected DoubleArrayList preProcessPhis(DoubleArrayList phis) {
        if (this.beta > 1.0) {
            phis = phis.copy();
            int i = phis.size();
            while (--i >= 0) {
                phis.set(i, (2.0 * phis.get(i) + this.beta - 1.0) / (2.0 * this.beta));
            }
        }
        return phis;
    }

    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        DoubleBuffer partial = this.bufferSet._getPartialBuffer();
        int missingValues = 0;
        if (partial != null) {
            missingValues = this.bufferSet.k() - partial.size();
            if (missingValues <= 0) {
                throw new IllegalStateException("Oops! illegal missing values.");
            }
            this.addInfinities(missingValues, partial);
            this.beta = (double)(this.totalElementsFilled + missingValues) / (double)this.totalElementsFilled;
        } else {
            this.beta = 1.0;
        }
        DoubleArrayList quantileElements = super.quantileElements(phis);
        if (partial != null) {
            KnownDoubleQuantileEstimator.removeInfinitiesFrom(missingValues, partial);
        }
        return quantileElements;
    }

    protected static void removeInfinitiesFrom(int infinities, DoubleBuffer buffer) {
        int plusInf = 0;
        int minusInf = 0;
        boolean even = true;
        for (int i = 0; i < infinities; ++i) {
            if (even) {
                ++plusInf;
            } else {
                ++minusInf;
            }
            even = !even;
        }
        buffer.values.removeFromTo(buffer.size() - plusInf, buffer.size() - 1);
        buffer.values.removeFromTo(0, minusInf - 1);
    }

    protected boolean sampleNextElement() {
        if (this.samplingAssistant == null) {
            return true;
        }
        return this.samplingAssistant.sampleNextElement();
    }
}

