/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.hebbian;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.decomposer.hebbian.EigenUpdater;
import org.apache.mahout.math.decomposer.hebbian.TrainingState;
import org.apache.mahout.math.function.PlusMult;

public class HebbianUpdater
implements EigenUpdater {
    public void update(Vector pseudoEigen, Vector trainingVector, TrainingState currentState) {
        double trainingVectorNorm = trainingVector.norm(2.0);
        int numPreviousEigens = currentState.getNumEigensProcessed();
        if (numPreviousEigens > 0 && currentState.isFirstPass()) {
            HebbianUpdater.updateTrainingProjectionsVector(currentState, trainingVector, numPreviousEigens - 1);
        }
        if (currentState.getActivationDenominatorSquared() == 0.0 || trainingVectorNorm == 0.0) {
            if (currentState.getActivationDenominatorSquared() == 0.0) {
                pseudoEigen.assign(trainingVector, new PlusMult(1.0));
                currentState.setHelperVector(currentState.currentTrainingProjection().clone());
                double helperNorm = currentState.getHelperVector().norm(2.0);
                currentState.setActivationDenominatorSquared(trainingVectorNorm * trainingVectorNorm - helperNorm * helperNorm);
            }
            return;
        }
        currentState.setActivationNumerator(pseudoEigen.dot(trainingVector));
        currentState.setActivationNumerator(currentState.getActivationNumerator() - currentState.getHelperVector().dot(currentState.currentTrainingProjection()));
        double activation = currentState.getActivationNumerator() / Math.sqrt(currentState.getActivationDenominatorSquared());
        currentState.setActivationDenominatorSquared(currentState.getActivationDenominatorSquared() + 2.0 * activation * currentState.getActivationNumerator() + activation * activation * (trainingVector.getLengthSquared() - currentState.currentTrainingProjection().getLengthSquared()));
        if (numPreviousEigens > 0) {
            currentState.getHelperVector().assign(currentState.currentTrainingProjection(), new PlusMult(activation));
        }
        pseudoEigen.assign(trainingVector, new PlusMult(activation));
    }

    private static void updateTrainingProjectionsVector(TrainingState state, Vector trainingVector, int previousEigenIndex) {
        Vector previousEigen = state.mostRecentEigen();
        Vector currentTrainingVectorProjection = state.currentTrainingProjection();
        double projection = previousEigen.dot(trainingVector);
        currentTrainingVectorProjection.set(previousEigenIndex, projection);
    }
}

