/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseRowMatrix
extends AbstractMatrix {
    private int[] cardinality;
    private Vector[] rows;
    private boolean randomAccessRows;

    public SparseRowMatrix() {
    }

    public SparseRowMatrix(int[] cardinality, Vector[] rows) {
        this(cardinality, rows, false, rows instanceof RandomAccessSparseVector[]);
    }

    public SparseRowMatrix(int[] cardinality, boolean randomAccess) {
        this(cardinality, randomAccess ? new RandomAccessSparseVector[cardinality[0]] : new SequentialAccessSparseVector[cardinality[0]], true, randomAccess);
    }

    public SparseRowMatrix(int[] cardinality, Vector[] rows, boolean shallowCopy, boolean randomAccess) {
        this.cardinality = (int[])cardinality.clone();
        this.randomAccessRows = randomAccess;
        this.rows = (Vector[])rows.clone();
        for (int row = 0; row < cardinality[0]; ++row) {
            if (rows[row] == null) {
                rows[row] = randomAccess ? new RandomAccessSparseVector(this.numCols(), 10) : new SequentialAccessSparseVector(this.numCols(), 10);
            }
            this.rows[row] = shallowCopy ? rows[row] : rows[row].clone();
        }
    }

    public SparseRowMatrix(int[] cardinality) {
        this(cardinality, true);
    }

    public int[] size() {
        return this.cardinality;
    }

    public Matrix clone() {
        SparseRowMatrix clone = (SparseRowMatrix)super.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        clone.rows = new Vector[this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            clone.rows[i] = this.rows[i].clone();
        }
        return clone;
    }

    public double getQuick(int row, int column) {
        if (this.rows[row] == null) {
            return 0.0;
        }
        return this.rows[row].getQuick(column);
    }

    public Matrix like() {
        return new SparseRowMatrix(this.cardinality, this.randomAccessRows);
    }

    public Matrix like(int rows, int columns) {
        int[] c = new int[]{rows, columns};
        return new SparseRowMatrix(c, this.randomAccessRows);
    }

    public void setQuick(int row, int column, double value) {
        this.rows[row].setQuick(column, value);
    }

    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[0] = this.rows.length;
        for (int row = 0; row < this.cardinality[0]; ++row) {
            result[1] = Math.max(result[1], this.rows[row].getNumNondefaultElements());
        }
        return result;
    }

    public Matrix viewPart(int[] offset, int[] size) {
        if (size[0] > this.rows.length || size[1] > this.rows[0].size()) {
            throw new CardinalityException();
        }
        if (offset[0] < 0 || offset[0] + size[0] > this.rows.length || offset[1] < 0 || offset[1] + size[1] > this.rows[0].size()) {
            throw new IndexException();
        }
        return new MatrixView(this, offset, size);
    }

    public Matrix assignColumn(int column, Vector other) {
        if (other.size() != this.cardinality[0] || column >= this.cardinality[1]) {
            throw new CardinalityException();
        }
        for (int row = 0; row < this.cardinality[0]; ++row) {
            this.rows[row].setQuick(column, other.getQuick(row));
        }
        return this;
    }

    public Matrix assignRow(int row, Vector other) {
        if (row >= this.cardinality[0] || other.size() != this.cardinality[1]) {
            throw new CardinalityException();
        }
        this.rows[row].assign(other);
        return this;
    }

    public Vector getColumn(int column) {
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException();
        }
        return new AbstractMatrix.TransposeViewVector((Matrix)this, column){

            protected Vector newVector(int cardinality) {
                return SparseRowMatrix.this.randomAccessRows ? new RandomAccessSparseVector(cardinality, 10) : new SequentialAccessSparseVector(cardinality, 10);
            }
        };
    }

    public Vector getRow(int row) {
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException();
        }
        return this.rows[row];
    }
}

