/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.Uniform;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;

@Deprecated
public class GenericPermuting {
    private GenericPermuting() {
    }

    public static int[] permutation(long p, int N) {
        if (p < 1L) {
            throw new IllegalArgumentException("Permutations are enumerated 1 .. N!");
        }
        if (N < 0) {
            throw new IllegalArgumentException("Must satisfy N >= 0");
        }
        int[] permutation = new int[N];
        if (N > 20) {
            int i = N;
            while (--i >= 0) {
                permutation[i] = i;
            }
            Uniform gen = new Uniform(new MersenneTwister((int)p));
            for (int i2 = 0; i2 < N - 1; ++i2) {
                int random = gen.nextIntFromTo(i2, N - 1);
                int tmp = permutation[random];
                permutation[random] = permutation[i2];
                permutation[i2] = tmp;
            }
            return permutation;
        }
        if (p > Arithmetic.longFactorial(N)) {
            throw new IllegalArgumentException("N too large (a sequence of N elements only has N! permutations).");
        }
        int[] tmp = new int[N];
        for (int i = 1; i <= N; ++i) {
            tmp[i - 1] = i;
        }
        long io = p - 1L;
        for (int M = N - 1; M >= 1; --M) {
            long fac = Arithmetic.longFactorial(M);
            int in = (int)(io / fac) + 1;
            io %= fac;
            permutation[N - M - 1] = tmp[in - 1];
            for (int j = in; j <= M; ++j) {
                tmp[j - 1] = tmp[j];
            }
        }
        if (N > 0) {
            permutation[N - 1] = tmp[0];
        }
        int i = N;
        while (--i >= 0) {
            int n = i;
            permutation[n] = permutation[n] - 1;
        }
        return permutation;
    }

    public static void permute(int[] list, int[] indexes) {
        int[] copy = (int[])list.clone();
        int i = list.length;
        while (--i >= 0) {
            list[i] = copy[indexes[i]];
        }
    }

    @Deprecated
    public static void permute(int[] indexes, Swapper swapper, int[] work) {
        GenericPermuting.permute(indexes, swapper, work, null);
    }

    public static void permute(int[] indexes, Swapper swapper, int[] work1, int[] work2) {
        int s = indexes.length;
        int[] tracks = work1;
        int[] pos = work2;
        if (tracks == null || tracks.length < s) {
            tracks = new int[s];
        }
        if (pos == null || pos.length < s) {
            pos = new int[s];
        }
        int i = s;
        while (--i >= 0) {
            tracks[i] = i;
            pos[i] = i;
        }
        for (i = 0; i < s; ++i) {
            int index = indexes[i];
            int track = tracks[index];
            if (i == track) continue;
            swapper.swap(i, track);
            tracks[index] = i;
            tracks[pos[i]] = track;
            int tmp = pos[i];
            pos[i] = pos[track];
            pos[track] = tmp;
        }
    }

    public static void permute(Object[] list, int[] indexes) {
        Object[] copy = (Object[])list.clone();
        int i = list.length;
        while (--i >= 0) {
            list[i] = copy[indexes[i]];
        }
    }
}

