/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.JsonVectorAdapter;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.UnboundLabelException;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVector
implements Vector {
    private transient Map<String, Integer> bindings;
    private String name;
    protected int size;
    protected double lengthSquared = -1.0;

    protected AbstractVector() {
        this(null, 0);
    }

    protected AbstractVector(String name) {
        this(name, 0);
    }

    protected AbstractVector(String name, int size) {
        this.name = name;
        this.size = size;
    }

    @Override
    public double aggregate(BinaryFunction aggregator, UnaryFunction map) {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result = aggregator.apply(result, map.apply(this.getQuick(i)));
        }
        return result;
    }

    @Override
    public double aggregate(Vector other, BinaryFunction aggregator, BinaryFunction combiner) {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result = aggregator.apply(result, combiner.apply(this.getQuick(i), other.getQuick(i)));
        }
        return result;
    }

    protected abstract Matrix matrixLike(int var1, int var2);

    @Override
    public Vector viewPart(int offset, int length) {
        if (length > this.size) {
            throw new CardinalityException();
        }
        if (offset < 0 || offset + length > this.size) {
            throw new IndexException();
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Vector clone() {
        AbstractVector clone;
        try {
            clone = (AbstractVector)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException(cnse);
        }
        if (this.bindings != null) {
            clone.bindings = (Map)((HashMap)this.bindings).clone();
        }
        return clone;
    }

    @Override
    public Vector divide(double x) {
        Vector result = this.clone();
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() / x);
        }
        return result;
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    public double dotSelf() {
        double result = 0.0;
        if (this instanceof DenseVector) {
            for (int i = 0; i < this.size(); ++i) {
                double value = this.getQuick(i);
                result += value * value;
            }
            return result;
        }
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            double value = iter.next().get();
            result += value * value;
        }
        return result;
    }

    @Override
    public double get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.getQuick(index);
        }
        throw new IndexException();
    }

    @Override
    public Vector minus(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException();
        }
        if (x instanceof RandomAccessSparseVector || x instanceof DenseVector) {
            Vector result = x.clone();
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element e = iter.next();
                result.setQuick(e.index(), e.get() - result.getQuick(e.index()));
            }
            return result;
        }
        Vector result = this.clone();
        Iterator<Vector.Element> iter = x.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = iter.next();
            result.setQuick(e.index(), this.getQuick(e.index()) - e.get());
        }
        return result;
    }

    @Override
    public Vector normalize() {
        return this.divide(Math.sqrt(this.dotSelf()));
    }

    @Override
    public Vector normalize(double power) {
        return this.divide(this.norm(power));
    }

    @Override
    public double norm(double power) {
        if (power < 0.0) {
            throw new IllegalArgumentException("Power must be >= 0");
        }
        if (Double.isInfinite(power)) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val = Math.max(val, Math.abs(iter.next().get()));
            }
            return val;
        }
        if (power == 2.0) {
            return Math.sqrt(this.dotSelf());
        }
        if (power == 1.0) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val += Math.abs(iter.next().get());
            }
            return val;
        }
        if (power == 0.0) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val += iter.next().get() == 0.0 ? 0.0 : 1.0;
            }
            return val;
        }
        double val = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            val += Math.pow(element.get(), power);
        }
        return Math.pow(val, 1.0 / power);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        this.lengthSquared = this.dotSelf();
        return this.lengthSquared;
    }

    @Override
    public double getDistanceSquared(Vector v) {
        Vector randomlyAccessed;
        Iterator<Vector.Element> it;
        if (v.size() != this.size()) {
            throw new CardinalityException();
        }
        if (this.lengthSquared >= 0.0 && v instanceof AbstractVector && ((AbstractVector)v).lengthSquared >= 0.0) {
            return this.lengthSquared + v.getLengthSquared() - 2.0 * this.dot(v);
        }
        double d = 0.0;
        if (this.lengthSquared >= 0.0) {
            it = v.iterateNonZero();
            randomlyAccessed = this;
            d += this.lengthSquared;
        } else {
            it = this.iterateNonZero();
            randomlyAccessed = v;
            d += v.getLengthSquared();
        }
        while (it.hasNext()) {
            Vector.Element e = it.next();
            double value = e.get();
            d += value * (value - 2.0 * randomlyAccessed.getQuick(e.index()));
        }
        assert (d > -1.0E-9);
        return Math.abs(d);
    }

    @Override
    public double maxValue() {
        double result = Double.NEGATIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            result = Math.max(result, element.get());
        }
        if (nonZeroElements < this.size()) {
            return Math.max(result, 0.0);
        }
        return result;
    }

    @Override
    public int maxValueIndex() {
        double tmp;
        Vector.Element element;
        int result = -1;
        double max = Double.NEGATIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            element = iter.next();
            tmp = element.get();
            if (!(tmp > max)) continue;
            max = tmp;
            result = element.index();
        }
        if (nonZeroElements < this.size() && max < 0.0) {
            iter = this.iterateAll();
            while (iter.hasNext()) {
                element = iter.next();
                tmp = element.get();
                if (tmp != 0.0) continue;
                return element.index();
            }
        }
        return result;
    }

    @Override
    public Vector plus(double x) {
        Vector result = this.clone();
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            result.setQuick(i, this.getQuick(i) + x);
        }
        return result;
    }

    @Override
    public Vector plus(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException();
        }
        Vector result = this.clone();
        Iterator<Vector.Element> iter = x.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = iter.next();
            int index = e.index();
            result.setQuick(index, this.getQuick(index) + e.get());
        }
        return result;
    }

    @Override
    public void addTo(Vector v) {
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            int index = e.index();
            v.setQuick(index, v.getQuick(index) + e.get());
        }
    }

    @Override
    public void set(int index, double value) {
        if (index < 0 || index >= this.size()) {
            throw new IndexException(index, this.size());
        }
        this.setQuick(index, value);
    }

    @Override
    public Vector times(double x) {
        Vector result = this.clone();
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() * x);
        }
        return result;
    }

    @Override
    public Vector times(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException();
        }
        Vector result = this.clone();
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() * x.getQuick(element.index()));
        }
        return result;
    }

    @Override
    public double zSum() {
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            result += iter.next().get();
        }
        return result;
    }

    @Override
    public Vector assign(double value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.setQuick(i, value);
        }
        return this;
    }

    @Override
    public Vector assign(double[] values) {
        if (values.length != this.size()) {
            throw new CardinalityException();
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.setQuick(i, values[i]);
        }
        return this;
    }

    @Override
    public Vector assign(Vector other) {
        if (other.size() != this.size()) {
            throw new CardinalityException();
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.setQuick(i, other.getQuick(i));
        }
        return this;
    }

    @Override
    public Vector assign(BinaryFunction f, double y) {
        Iterator<Vector.Element> it = f.apply(0.0, y) == 0.0 ? this.iterateNonZero() : this.iterateAll();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            e.set(f.apply(e.get(), y));
        }
        return this;
    }

    @Override
    public Vector assign(UnaryFunction function) {
        Iterator<Vector.Element> it = function.apply(0.0) == 0.0 ? this.iterateNonZero() : this.iterateAll();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            e.set(function.apply(e.get()));
        }
        return this;
    }

    @Override
    public Vector assign(Vector other, BinaryFunction function) {
        if (other.size() != this.size()) {
            throw new CardinalityException();
        }
        for (int i = 0; i < this.size(); ++i) {
            this.setQuick(i, function.apply(this.getQuick(i), other.getQuick(i)));
        }
        return this;
    }

    @Override
    public Matrix cross(Vector other) {
        Matrix result = this.matrixLike(this.size(), other.size());
        for (int row = 0; row < this.size(); ++row) {
            result.assignRow(row, other.times(this.getQuick(row)));
        }
        return result;
    }

    public static Vector decodeVector(String formattedString) {
        Type vectorType = new TypeToken<Vector>(){}.getType();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(vectorType, (Object)new JsonVectorAdapter());
        Gson gson = builder.create();
        return (Vector)gson.fromJson(formattedString, vectorType);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String asFormatString() {
        Type vectorType = new TypeToken<Vector>(){}.getType();
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(vectorType, (Object)new JsonVectorAdapter());
        Gson gson = builder.create();
        return gson.toJson((Object)this, vectorType);
    }

    public static boolean equivalent(Vector left, Vector right) {
        if (left == right) {
            return true;
        }
        int leftCardinality = left.size();
        if (leftCardinality == right.size()) {
            for (int i = 0; i < leftCardinality; ++i) {
                if (left.getQuick(i) == right.getQuick(i)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean strictEquivalence(Vector left, Vector right) {
        if (left == right) {
            return true;
        }
        if (!left.getClass().equals(right.getClass())) {
            return false;
        }
        String leftName = left.getName();
        String rightName = right.getName();
        if (leftName != null && rightName != null && !leftName.equals(rightName)) {
            return false;
        }
        if (leftName != null && rightName == null || rightName != null && leftName == null) {
            return false;
        }
        int leftCardinality = left.size();
        if (leftCardinality == right.size()) {
            for (int i = 0; i < leftCardinality; ++i) {
                if (left.getQuick(i) == right.getQuick(i)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = prime + (this.name == null ? 0 : this.name.hashCode());
        result = prime * result + this.size();
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element ele = iter.next();
            long v = Double.doubleToLongBits(ele.get());
            result += ele.index() * (int)(v ^ v >> 32);
        }
        return result;
    }

    @Override
    public double get(String label) throws IndexException, UnboundLabelException {
        if (this.bindings == null) {
            throw new UnboundLabelException();
        }
        Integer index = this.bindings.get(label);
        if (index == null) {
            throw new UnboundLabelException();
        }
        return this.get(index);
    }

    @Override
    public Map<String, Integer> getLabelBindings() {
        return this.bindings;
    }

    @Override
    public void set(String label, double value) throws IndexException, UnboundLabelException {
        if (this.bindings == null) {
            throw new UnboundLabelException();
        }
        Integer index = this.bindings.get(label);
        if (index == null) {
            throw new UnboundLabelException();
        }
        this.set(index, value);
    }

    @Override
    public void setLabelBindings(Map<String, Integer> bindings) {
        this.bindings = bindings;
    }

    @Override
    public void set(String label, int index, double value) throws IndexException {
        if (this.bindings == null) {
            this.bindings = new HashMap<String, Integer>();
        }
        this.bindings.put(label, index);
        this.set(index, value);
    }
}

