/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SystemIdResolver;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DebugLogger;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataImportHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger LOG = LoggerFactory.getLogger(DataImportHandler.class);
    private DataImporter importer;
    private Map<String, Properties> dataSources = new HashMap<String, Properties>();
    private List<SolrInputDocument> debugDocuments = Collections.synchronizedList(new ArrayList());
    private boolean debugEnabled = true;
    private String myName = "dataimport";
    private Map<String, Object> coreScopeSession = new HashMap<String, Object>();
    public static final String ENABLE_DEBUG = "enableDebug";

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        try {
            String configLoc;
            for (Map.Entry e : core.getRequestHandlers().entrySet()) {
                SolrRequestHandler handler = (SolrRequestHandler)e.getValue();
                if (this != handler) continue;
                String name = (String)e.getKey();
                if (name.startsWith("/")) {
                    this.myName = name.substring(1);
                }
                this.myName = this.myName.replaceAll("/", "_");
            }
            this.debugEnabled = StrUtils.parseBool((String)((String)this.initArgs.get(ENABLE_DEBUG)), (boolean)true);
            NamedList defaults = (NamedList)this.initArgs.get("defaults");
            if (defaults != null && (configLoc = (String)defaults.get("config")) != null && configLoc.length() != 0) {
                this.processConfiguration(defaults);
                InputSource is = new InputSource(core.getResourceLoader().openConfig(configLoc));
                is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)configLoc));
                this.importer = new DataImporter(is, core, this.dataSources, this.coreScopeSession);
            }
        }
        catch (Throwable e) {
            SolrConfig.severeErrors.add(e);
            LOG.error("Exception while loading DataImporter", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FATAL: Could not create importer. DataImporter config invalid", e);
        }
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Iterator i$;
        rsp.setHttpCaching(false);
        SolrParams params = req.getParams();
        DataImporter.RequestParams requestParams = new DataImporter.RequestParams(this.getParamsMap(params));
        String command = requestParams.command;
        Iterable streams = req.getContentStreams();
        if (streams != null && (i$ = streams.iterator()).hasNext()) {
            ContentStream stream;
            requestParams.contentStream = stream = (ContentStream)i$.next();
        }
        if ("show-config".equals(command)) {
            ModifiableSolrParams rawParams = new ModifiableSolrParams(req.getParams());
            rawParams.set("wt", new String[]{"raw"});
            req.setParams((SolrParams)rawParams);
            String dataConfigFile = this.defaults.get("config");
            ContentStreamBase.StringStream content = new ContentStreamBase.StringStream(SolrWriter.getResourceAsString(req.getCore().getResourceLoader().openResource(dataConfigFile)));
            rsp.add("content", (Object)content);
            return;
        }
        rsp.add("initArgs", (Object)this.initArgs);
        String message = "";
        if (command != null) {
            rsp.add("command", (Object)command);
        }
        if (requestParams.debug && (this.importer == null || !this.importer.isBusy())) {
            this.importer = null;
            if (requestParams.dataConfig != null) {
                try {
                    this.processConfiguration((NamedList)this.initArgs.get("defaults"));
                    this.importer = new DataImporter(new InputSource(new StringReader(requestParams.dataConfig)), req.getCore(), this.dataSources, this.coreScopeSession);
                }
                catch (RuntimeException e) {
                    rsp.add("exception", (Object)DebugLogger.getStacktraceString(e));
                    this.importer = null;
                    return;
                }
            } else {
                this.inform(req.getCore());
            }
            message = "Configuration Re-loaded sucessfully";
        }
        if (this.importer == null) {
            rsp.add("status", (Object)"DataImportHandler started. Not Initialized. No commands can be run");
            return;
        }
        if (command != null && "abort".equals(command)) {
            this.importer.runCmd(requestParams, null);
        } else if (this.importer.isBusy()) {
            message = "A command is still running...";
        } else if (command != null) {
            if ("full-import".equals(command) || "delta-import".equals(command) || "import".equals(command)) {
                UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(SolrPluginUtils.resolveUpdateChainParam((SolrParams)params, (Logger)LOG));
                UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
                SolrResourceLoader loader = req.getCore().getResourceLoader();
                SolrWriter sw = this.getSolrWriter(processor, loader, requestParams);
                if (requestParams.debug) {
                    if (this.debugEnabled) {
                        this.importer.runCmd(requestParams, sw);
                        rsp.add("mode", (Object)"debug");
                        rsp.add("documents", this.debugDocuments);
                        if (sw.debugLogger != null) {
                            rsp.add("verbose-output", (Object)sw.debugLogger.output);
                        }
                        this.debugDocuments.clear();
                    } else {
                        message = "Debug not enabled. Add a tag <str name=\"enableDebug\">true</str> in solrconfig.xml";
                    }
                } else if (requestParams.contentStream == null && !requestParams.syncMode) {
                    this.importer.runAsync(requestParams, sw);
                } else {
                    this.importer.runCmd(requestParams, sw);
                }
            } else if ("reload-config".equals(command)) {
                this.importer = null;
                this.inform(req.getCore());
                message = "Configuration Re-loaded sucessfully";
            }
        }
        rsp.add("status", (Object)(this.importer.isBusy() ? "busy" : "idle"));
        rsp.add("importResponse", (Object)message);
        rsp.add("statusMessages", this.importer.getStatusMessages());
        RequestHandlerUtils.addExperimentalFormatWarning((SolrQueryResponse)rsp);
    }

    private Map<String, Object> getParamsMap(SolrParams params) {
        Iterator names = params.getParameterNamesIterator();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (names.hasNext()) {
            String s = (String)names.next();
            String[] val = params.getParams(s);
            if (val == null || val.length < 1) continue;
            if (val.length == 1) {
                result.put(s, val[0]);
                continue;
            }
            result.put(s, Arrays.asList(val));
        }
        return result;
    }

    private void processConfiguration(NamedList defaults) {
        if (defaults == null) {
            LOG.info("No configuration specified in solrconfig.xml for DataImportHandler");
            return;
        }
        LOG.info("Processing configuration from solrconfig.xml: " + defaults);
        this.dataSources = new HashMap<String, Properties>();
        for (int position = 0; position < defaults.size() && defaults.getName(position) != null; ++position) {
            String name = defaults.getName(position);
            if (!name.equals("datasource")) continue;
            NamedList dsConfig = (NamedList)defaults.getVal(position);
            Properties props = new Properties();
            for (int i = 0; i < dsConfig.size(); ++i) {
                props.put(dsConfig.getName(i), dsConfig.getVal(i));
            }
            LOG.info("Adding properties to datasource: " + props);
            this.dataSources.put((String)dsConfig.get("name"), props);
        }
    }

    private SolrWriter getSolrWriter(UpdateRequestProcessor processor, SolrResourceLoader loader, final DataImporter.RequestParams requestParams) {
        return new SolrWriter(processor, loader.getConfigDir(), this.myName){

            public boolean upload(SolrInputDocument document) {
                try {
                    if (requestParams.debug) {
                        DataImportHandler.this.debugDocuments.add(document);
                    }
                    return super.upload(document);
                }
                catch (RuntimeException e) {
                    LOG.error("Exception while adding: " + document, (Throwable)e);
                    return false;
                }
            }
        };
    }

    public NamedList getStatistics() {
        if (this.importer == null) {
            return super.getStatistics();
        }
        DocBuilder.Statistics cumulative = this.importer.cumulativeStatistics;
        NamedList result = new NamedList();
        result.add("Status", (Object)this.importer.getStatus().toString());
        if (this.importer.docBuilder != null) {
            DocBuilder.Statistics running = this.importer.docBuilder.importStatistics;
            result.add("Documents Processed", (Object)running.docCount);
            result.add("Requests made to DataSource", (Object)running.queryCount);
            result.add("Rows Fetched", (Object)running.rowsCount);
            result.add("Documents Deleted", (Object)running.deletedDocCount);
            result.add("Documents Skipped", (Object)running.skipDocCount);
        }
        result.add("Total Documents Processed", (Object)cumulative.docCount);
        result.add("Total Requests made to DataSource", (Object)cumulative.queryCount);
        result.add("Total Rows Fetched", (Object)cumulative.rowsCount);
        result.add("Total Documents Deleted", (Object)cumulative.deletedDocCount);
        result.add("Total Documents Skipped", (Object)cumulative.skipDocCount);
        NamedList requestStatistics = super.getStatistics();
        if (requestStatistics != null) {
            for (int i = 0; i < requestStatistics.size(); ++i) {
                result.add(requestStatistics.getName(i), requestStatistics.getVal(i));
            }
        }
        return result;
    }

    public String getDescription() {
        return "Manage data import from databases to Solr";
    }

    public String getSourceId() {
        return "$Id: DataImportHandler.java 1171306 2011-09-15 22:43:33Z janhoy $";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_5/solr/contrib/dataimporthandler/src/java/org/apache/solr/handler/dataimport/DataImportHandler.java $";
    }
}

